/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.foundations;

import com.azul.gulp.Analyzer;
import com.azul.gulp.GroupBuilder;
import com.azul.gulp.GroupingProcessor;
import com.azul.gulp.Groups;
import com.azul.gulp.GulpPairStream;
import com.azul.gulp.GulpStream;
import com.azul.gulp.GulpStreamExtension;
import com.azul.gulp.IndexedProcessor;
import com.azul.gulp.Pair;
import com.azul.gulp.ParameterizedAnalyzer;
import com.azul.gulp.ParameterizedResult;
import com.azul.gulp.Processor;
import com.azul.gulp.Range;
import com.azul.gulp.Result;
import com.azul.gulp.StreamProcessingException;
import com.azul.gulp.ThrowingFunction;
import com.azul.gulp.foundations.GulpPairStreamImpl;
import com.azul.gulp.foundations.GulpStreamPlain;
import com.azul.gulp.foundations.StreamCore;
import com.azul.gulp.functional.Predicates;
import com.azul.gulp.functional.inject.InjectionAwareFunction;
import com.azul.gulp.functional.inject.InjectionAwarePredicate;
import com.azul.gulp.inject.InjectionAware;
import com.azul.gulp.inject.InjectionContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;

public class GulpStreamBase<E extends GulpStreamExtension<E, T>, T>
implements GulpStreamExtension<E, T> {
    protected final StreamCore<? extends T> core;

    public GulpStreamBase(StreamCore<? extends T> core) {
        this.core = core;
    }

    public GulpStreamBase(GulpStream<? extends T> wrapped) {
        this.core = GulpStreamBase.asCore(wrapped);
    }

    static <T> StreamCore<? extends T> asCore(final GulpStream<? extends T> wrapped) {
        if (wrapped instanceof GulpStreamBase) {
            GulpStreamBase wrappedBase = (GulpStreamBase)wrapped;
            return wrappedBase.core;
        }
        return new StreamCore<T>(){

            @Override
            protected void processImpl(Processor<? super T> processor) {
                wrapped.process(processor);
            }
        };
    }

    @Override
    public Result process(Processor<? super T> processor) {
        this.core.process(processor);
        return new Result(processor);
    }

    @Override
    public void forEach(Processor<? super T> processor) {
        this.core.process(processor);
    }

    @Override
    public void forEachIndexed(final IndexedProcessor<? super T> indexedProcessor) {
        this.core.process(new Processor<T>(){
            int index = 0;

            @Override
            public final void process(T object) throws Exception {
                indexedProcessor.process(this.index, object);
                ++this.index;
            }
        });
    }

    @Override
    public final GulpStream<T> beforeInclusive(Predicate<? super T> predicate) {
        return this.before(predicate, true);
    }

    @Override
    public final GulpStream<T> beforeExclusive(Predicate<? super T> predicate) {
        return this.before(predicate, false);
    }

    @Override
    public final GulpStream<T> before(final Predicate<? super T> predicate, final boolean inclusive) {
        final class BeforePredicateImpl
        implements InjectionAwarePredicate<T> {
            private boolean matched = false;

            BeforePredicateImpl() {
            }

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(predicate);
            }

            @Override
            public boolean test(T value) {
                if (this.matched) {
                    return false;
                }
                boolean curMatched = predicate.test(value);
                if (curMatched) {
                    this.matched = true;
                    return inclusive;
                }
                return true;
            }
        }
        return this.filter((Predicate)new BeforePredicateImpl());
    }

    @Override
    public final GulpStream<T> afterInclusive(Predicate<? super T> predicate) {
        return this.after(predicate, true);
    }

    @Override
    public final GulpStream<T> afterExclusive(Predicate<? super T> predicate) {
        return this.after(predicate, false);
    }

    @Override
    public final GulpStream<T> after(final Predicate<? super T> predicate, final boolean inclusive) {
        final class AfterPredicateImpl
        implements InjectionAwarePredicate<T> {
            private boolean matched = false;

            AfterPredicateImpl() {
            }

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(predicate);
            }

            @Override
            public boolean test(T value) {
                if (this.matched) {
                    return true;
                }
                boolean curMatched = predicate.test(value);
                if (curMatched) {
                    this.matched = true;
                    return inclusive;
                }
                return false;
            }
        }
        return this.filter((Predicate)new AfterPredicateImpl());
    }

    @Override
    public final GulpStream<T> skip(final int count) {
        return this.filterOut(new Predicate<T>(){
            int seen = 0;

            @Override
            public final boolean test(T value) {
                ++this.seen;
                return this.seen <= count;
            }
        });
    }

    @Override
    public final GulpStream<T> limit(final int count) {
        return this.filter(new Predicate<T>(){
            int seen = 0;

            @Override
            public final boolean test(T value) {
                ++this.seen;
                return this.seen <= count;
            }
        });
    }

    @Override
    public <R> Result<R> extractRange(final GulpStream.RangeFactory<? super T, ? extends R> rangeFactory) {
        return this.analyze(new Analyzer<T, R>(){
            private T min = null;
            private T max = null;

            @Override
            public final void process(T object) throws Exception {
                if (this.min == null) {
                    this.min = object;
                    this.max = object;
                } else {
                    int maxCmp;
                    int minCmp = Objects.compare(object, this.min, GenericComparator.INSTANCE);
                    if (minCmp == -1) {
                        this.min = object;
                    }
                    if ((maxCmp = Objects.compare(object, this.max, GenericComparator.INSTANCE)) == 1) {
                        this.max = object;
                    }
                }
            }

            @Override
            public final R result() {
                if (this.min == null) {
                    return null;
                }
                return rangeFactory.make(this.min, this.max);
            }
        });
    }

    @Override
    public <K> Groups<K, T> group(final GroupingProcessor<K, T> groupingProcessor) {
        class InjectableGroupingAnalyzer
        implements Analyzer<T, Groups<K, T>>,
        InjectionAware {
            private final GroupBuilder<K, T> groupBuilder = new GroupBuilder();

            InjectableGroupingAnalyzer() {
            }

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(groupingProcessor);
            }

            @Override
            public void process(T element) throws Exception {
                groupingProcessor.process(this.groupBuilder, element);
            }

            @Override
            public final Groups<K, T> result() {
                return this.groupBuilder.result();
            }
        }
        return (Groups)this.analyze(new InjectableGroupingAnalyzer()).get();
    }

    @Override
    public <K> Groups<K, T> groupBy(final ThrowingFunction<? super T, ? extends K> groupFn) {
        class InjectableGroupingProcessor
        implements GroupingProcessor<K, T>,
        InjectionAware {
            InjectableGroupingProcessor() {
            }

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(groupFn);
            }

            @Override
            public final void process(GroupBuilder<K, T> groupBuilder, T element) throws Exception {
                Object groupKey = groupFn.apply(element);
                groupBuilder.add(groupKey, element);
            }
        }
        return this.group(new InjectableGroupingProcessor());
    }

    @Override
    public final Groups<Integer, T> groupEvery(final int count) {
        return this.group(new GroupingProcessor<Integer, T>(){
            private int groupCount = 0;
            private int groupNum = 0;

            @Override
            public final void process(GroupBuilder<Integer, T> groupBuilder, T element) throws Exception {
                ++this.groupCount;
                if (this.groupCount == count) {
                    ++this.groupNum;
                    this.groupCount = 1;
                }
                groupBuilder.add(this.groupNum, element);
            }
        });
    }

    @Override
    public final Groups<Integer, T> splitOn(final Predicate<? super T> predicateFn) {
        class InjectableGroupingProcessor
        implements GroupingProcessor<Integer, T>,
        InjectionAware {
            Integer groupNum = null;

            InjectableGroupingProcessor() {
            }

            @Override
            public final void onInject(InjectionContext ctx) {
                ctx.inject(predicateFn);
            }

            @Override
            public final void process(GroupBuilder<Integer, T> groupBuilder, T element) throws Exception {
                if (this.groupNum == null) {
                    this.groupNum = 1;
                } else if (predicateFn.test(element)) {
                    this.groupNum = this.groupNum + 1;
                }
                groupBuilder.add(this.groupNum, element);
            }
        }
        return this.group(new InjectableGroupingProcessor());
    }

    @Override
    public final Groups<Integer, T> splitOn(T value) {
        return this.splitOn((T)((Predicate<Object>)e -> Objects.equals(e, value)));
    }

    @Override
    public <V> Result<Range<V>> range(final ThrowingFunction<? super T, ? extends V> lowerFn, final ThrowingFunction<? super T, ? extends V> upperFn) {
        class InjectableMapper
        implements ThrowingFunction<T, Iterable<V>>,
        InjectionAware {
            InjectableMapper() {
            }

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(lowerFn);
                ctx.inject(upperFn);
            }

            @Override
            public Iterable<V> apply(T input) throws Exception {
                return Arrays.asList(lowerFn.apply(input), upperFn.apply(input));
            }
        }
        return this.flatMap(new InjectableMapper()).range();
    }

    @Override
    public Result<Range<T>> range() {
        return this.extractRange(Range::make);
    }

    @Override
    public <V> Result<Range<V>> range(ThrowingFunction<? super T, ? extends V> mapFn) {
        GulpStream<V> mapped = this.map(mapFn);
        return mapped.range();
    }

    @Override
    public final Result<T> min() {
        return this.range().map((? super T range) -> range == null ? null : range.start);
    }

    @Override
    public <V> Result<V> min(ThrowingFunction<? super T, ? extends V> mapFn) {
        GulpStream<V> mapped = this.map(mapFn);
        return mapped.min();
    }

    @Override
    public final Result<T> max() {
        return this.range().map((? super T range) -> range == null ? null : range.end);
    }

    @Override
    public <V> Result<V> max(ThrowingFunction<? super T, ? extends V> mapFn) {
        GulpStream<V> mapped = this.map(mapFn);
        return mapped.max();
    }

    @Override
    public <C extends Comparable<C>> GulpStream<T> sortBy(ThrowingFunction<? super T, ? extends C> mapFn) {
        return this.sortByImpl(mapFn, false);
    }

    @Override
    public <C extends Comparable<C>> GulpStream<T> sortByDescending(ThrowingFunction<? super T, ? extends C> mapFn) {
        return this.sortByImpl(mapFn, true);
    }

    private <C extends Comparable<C>> GulpStream<T> sortByImpl(final ThrowingFunction<? super T, ? extends C> mapFn, boolean invert) {
        class InjectableMappingComparator
        implements Comparator<T>,
        InjectionAware {
            InjectableMappingComparator() {
            }

            @Override
            public final void onInject(InjectionContext ctx) {
                ctx.inject(mapFn);
            }

            @Override
            public final int compare(T lhs, T rhs) {
                try {
                    Comparable mappedLhs = (Comparable)mapFn.apply(lhs);
                    Comparable mappedRhs = (Comparable)mapFn.apply(rhs);
                    return mappedLhs.compareTo(mappedRhs);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return this.sortImpl(new InjectableMappingComparator(), invert);
    }

    @Override
    public final GulpStream<T> sort() {
        GenericComparator comparator = GenericComparator.INSTANCE;
        return this.sortImpl(comparator, false);
    }

    @Override
    public GulpStream<T> sortDescending() {
        GenericComparator comparator = GenericComparator.INSTANCE;
        return this.sortImpl(comparator, true);
    }

    @Override
    public final GulpStream<T> sortUsing(Comparator<? super T> comparator) {
        return this.sortImpl(comparator, false);
    }

    private GulpStream<T> sortImpl(Comparator<? super T> comparator, boolean invert) {
        final InjectionContext injectionCtx = this.core.injectionContext();
        injectionCtx.inject(comparator);
        final Comparator finalComparator = invert ? (lhs, rhs) -> comparator.compare(rhs, lhs) : comparator;
        return new GulpStreamPlain(new StreamCore<T>(){
            private List<T> sorted = null;

            @Override
            protected final InjectionContext injectionContext() {
                return injectionCtx;
            }

            @Override
            protected void processImpl(Processor<? super T> processor) {
                if (this.sorted == null) {
                    this.sorted = GulpStreamBase.this.toList();
                    this.sorted.sort(finalComparator);
                }
                try {
                    for (Object element : this.sorted) {
                        processor.process(element);
                    }
                }
                catch (Exception e) {
                    throw new StreamProcessingException(e);
                }
            }
        });
    }

    @Override
    public <R> Result<R> analyze(Analyzer<? super T, ? extends R> analyzer) throws StreamProcessingException {
        this.core.process(analyzer);
        return new Result(analyzer);
    }

    @Override
    public <R> R analyzeAndGet(Analyzer<? super T, ? extends R> analyzer) throws StreamProcessingException {
        return (R)this.analyze(analyzer).get();
    }

    @Override
    public <P, R> ParameterizedResult<P, R> analyze(ParameterizedAnalyzer<? super T, ? super P, ? extends R> analyzer) throws StreamProcessingException {
        this.core.process(analyzer);
        return new ParameterizedResult(analyzer);
    }

    @Override
    public boolean matchesOne(Predicate<? super T> predicate) {
        return this.first(predicate) != null;
    }

    @Override
    public boolean matchesOne(Set<? super T> set) {
        return this.first(set) != null;
    }

    @Override
    public Optional<T> first() {
        return (Optional)this.analyze(new Analyzer<T, Optional<T>>(){
            T first = null;

            @Override
            public final void process(T object) {
                if (this.first == null) {
                    this.first = object;
                }
            }

            @Override
            public final Optional<T> result() {
                return Optional.ofNullable(this.first);
            }
        }).get();
    }

    @Override
    public Optional<T> first(Predicate<? super T> predicate) {
        return this.filter((Predicate)predicate).first();
    }

    @Override
    public Optional<T> first(Set<? super T> set) {
        return this.first(set::contains);
    }

    @Override
    public Optional<T> last() {
        return (Optional)this.analyze(new Analyzer<T, Optional<T>>(){
            T last = null;

            @Override
            public final void process(T object) {
                this.last = object;
            }

            @Override
            public final Optional<T> result() {
                return Optional.ofNullable(this.last);
            }
        }).get();
    }

    @Override
    public Optional<T> last(Predicate<? super T> predicate) {
        return this.filter((Predicate)predicate).last();
    }

    @Override
    public Optional<T> last(Set<? super T> set) {
        return this.last(set::contains);
    }

    protected E createOffspring(StreamCore<? extends T> core) {
        GulpStreamBase<E, ? extends T> casted = new GulpStreamBase<E, T>(core);
        return (E)casted;
    }

    protected final <U> GulpStream<U> createDerivative(StreamCore<? extends U> core) {
        return new GulpStreamBase<E, U>(core);
    }

    protected final <F, S> GulpPairStream<F, S> createPairDerivative(StreamCore<? extends Pair<F, S>> core) {
        return new GulpPairStreamImpl(core);
    }

    @Override
    public boolean contains(T element) {
        return (Integer)this.filter(new Object[]{element}).count().get() != 0;
    }

    @Override
    public boolean contains(Predicate<? super T> predicate) {
        return (Integer)this.filter((Predicate)predicate).count().get() != 0;
    }

    @Override
    public E filter(Predicate<? super T> predicate) {
        return this.createOffspring(this.core.filter(predicate));
    }

    @Override
    public E filter(Set<? super T> set) {
        return (E)this.filter(set::contains);
    }

    @Override
    public final E filter(T ... ts) {
        HashSet<T> set = new HashSet<T>(ts.length);
        set.addAll(Arrays.asList(ts));
        return (E)this.filter(set);
    }

    @Override
    public E filterOut(Predicate<? super T> predicate) {
        return (E)this.filter((Predicate)Predicates.not(predicate));
    }

    @Override
    public final E filterOut(Set<? super T> set) {
        return (E)this.filterOut(set::contains);
    }

    @Override
    public final E filterOut(T ... ts) {
        HashSet<T> set = new HashSet<T>(ts.length);
        set.addAll(Arrays.asList(ts));
        return (E)this.filterOut(set);
    }

    @Override
    public E unique() {
        return (E)this.filter(Predicates.unique());
    }

    @Override
    public E unique(ThrowingFunction<? super T, ?> identityFn) {
        return (E)this.filter((Predicate)Predicates.unique(identityFn));
    }

    @Override
    public Result<Integer> count() {
        return this.analyze(new Analyzer<T, Integer>(){
            int count = 0;

            @Override
            public final void process(T object) {
                ++this.count;
            }

            @Override
            public final Integer result() {
                return this.count;
            }
        });
    }

    @Override
    public <U> GulpStream<U> flatMap(ThrowingFunction<? super T, ? extends Iterable<? extends U>> transform) {
        return this.createDerivative(this.core.flatMap(transform));
    }

    @Override
    public <U> GulpStream<U> map(ThrowingFunction<? super T, ? extends U> transform) {
        return this.createDerivative(this.core.map(transform));
    }

    @Override
    public <U> GulpStream<U> map(Map<? super T, ? extends U> map) {
        return this.map((? super T t) -> map.get(t));
    }

    @Override
    public <U, V> GulpPairStream<U, V> map(final ThrowingFunction<? super T, ? extends U> firstMap, final ThrowingFunction<? super T, ? extends V> secondMap) {
        InjectionAwareFunction pairFn = new InjectionAwareFunction<T, Pair<U, V>>(){

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(firstMap);
                ctx.inject(secondMap);
            }

            @Override
            public Pair<U, V> apply(T input) throws Exception {
                return Pair.make(firstMap.apply(input), secondMap.apply(input));
            }
        };
        return this.createPairDerivative(this.core.map(pairFn));
    }

    @Override
    public GulpStream<Boolean> predicateMap(Predicate<? super T> predicate) {
        return this.map(Predicates.asFunction(predicate));
    }

    @Override
    public final void addTo(Collection<? super T> collection) {
        this.process(collection::add);
    }

    @Override
    public final List<T> toList(Predicate<? super T> predicate) {
        return this.filter((Predicate)predicate).toList();
    }

    @Override
    public final List<T> toList() {
        ArrayList list = new ArrayList();
        this.process(list::add);
        return list;
    }

    @Override
    public final List<T> toList(int maxElements) {
        List<T> list = this.toList();
        return list.subList(0, Math.min(maxElements, list.size()));
    }

    @Override
    public final Set<T> toSet(Predicate<? super T> predicate) {
        return this.filter((Predicate)predicate).toSet();
    }

    @Override
    public final Set<T> toSet() {
        HashSet set = new HashSet();
        this.process(set::add);
        return set;
    }

    @Override
    public final SortedSet<T> toSortedSet(Predicate<? super T> predicate) {
        return this.filter((Predicate)predicate).toSortedSet();
    }

    @Override
    public final SortedSet<T> toSortedSet() {
        TreeSet set = new TreeSet();
        this.process(set::add);
        return set;
    }

    @Override
    public final <K> Map<K, T> toMap(ThrowingFunction<? super T, ? extends K> keyFn) {
        HashMap map = new HashMap();
        this.process(e -> map.put(keyFn.apply((Object)e), e));
        return map;
    }

    @Override
    public <K, V> Map<K, V> toMap(ThrowingFunction<? super T, ? extends K> keyFn, ThrowingFunction<? super T, ? extends V> valueFn) {
        HashMap map = new HashMap();
        this.process(e -> map.put(keyFn.apply((Object)e), valueFn.apply((Object)e)));
        return map;
    }

    @Override
    public <K extends Comparable<?>> SortedMap<K, T> toSortedMap(ThrowingFunction<? super T, ? extends K> keyFn) {
        TreeMap map = new TreeMap();
        this.process(e -> map.put((Comparable)keyFn.apply((Object)e), e));
        return map;
    }

    @Override
    public <K, V> SortedMap<K, V> toSortedMap(ThrowingFunction<? super T, ? extends K> keyFn, ThrowingFunction<? super T, ? extends V> valueFn) {
        TreeMap map = new TreeMap();
        this.process(e -> map.put(keyFn.apply((Object)e), valueFn.apply((Object)e)));
        return map;
    }

    @Override
    public final void print() {
        this.printTo(System.out);
    }

    @Override
    public final void printTo(PrintStream out) {
        this.process(out::println);
        out.println();
    }

    @Override
    public final void printTo(OutputStream out) {
        this.printTo(new PrintStream(out, true));
    }

    @Override
    public final void printTo(Writer writer) {
        this.process(obj -> {
            writer.write(obj.toString());
            writer.write(10);
        });
        try {
            writer.write(10);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void print(ThrowingFunction<? super T, ? extends String> fn) {
        this.map(fn).print();
    }

    private static final class GenericComparator
    implements Comparator<Object> {
        private static final GenericComparator INSTANCE = new GenericComparator();

        private GenericComparator() {
        }

        @Override
        public final int compare(Object lhs, Object rhs) {
            if (lhs instanceof Comparable && rhs instanceof Comparable) {
                Comparable lhsComparable = (Comparable)lhs;
                Comparable rhsComparable = (Comparable)rhs;
                return lhsComparable.compareTo(rhsComparable);
            }
            throw new IllegalArgumentException();
        }
    }
}

