/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.functional;

import com.azul.gulp.Processor;
import com.azul.gulp.ThrowingFunction;
import com.azul.gulp.functional.inject.InjectionAwareProcessor;
import com.azul.gulp.inject.InjectionContext;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public final class Processors {
    private Processors() {
    }

    public static <T> Processor<T> filter(final Predicate<? super T> predicate, final Processor<? super T> processor) {
        return new InjectionAwareProcessor<T>(){

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(predicate);
                ctx.inject(processor);
            }

            @Override
            public void process(T object) throws Exception {
                if (predicate.test(object)) {
                    processor.process(object);
                }
            }
        };
    }

    public static <T, U> Processor<T> map(final ThrowingFunction<? super T, ? extends U> mappingFn, final Processor<? super U> processor) {
        return new InjectionAwareProcessor<T>(){

            @Override
            public void onInject(InjectionContext ctx) {
                ctx.inject(mappingFn);
                ctx.inject(processor);
            }

            @Override
            public final void process(T object) throws Exception {
                processor.process(mappingFn.apply(object));
            }
        };
    }

    public static <T> Processor<T> addTo(final Collection<? super T> collection) {
        return new Processor<T>(){

            @Override
            public void process(T object) {
                collection.add(object);
            }
        };
    }

    public static <K, V> Processor<V> addToMap(final Map<? super K, ? super V> map, final ThrowingFunction<? super V, ? extends K> keyFn) {
        return new Processor<V>(){

            @Override
            public void process(V object) throws Exception {
                map.put(keyFn.apply(object), object);
            }
        };
    }
}

