/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.inject;

import com.azul.gulp.Gulp;
import com.azul.gulp.inject.ExactInjector;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FieldInjector
implements ExactInjector {
    private final Object target;
    private final List<Field> injectableFields;

    public FieldInjector(Object target) {
        this.target = target;
        this.injectableFields = FieldInjector.getInjectableFields(target.getClass());
    }

    private static List<Field> getInjectableFields(Class<?> type) {
        ArrayList<Field> injectableFields = new ArrayList<Field>();
        for (Field field : type.getFields()) {
            if (!field.isAnnotationPresent(Gulp.Inject.class)) continue;
            injectableFields.add(field);
        }
        for (Field field : type.getDeclaredFields()) {
            if (FieldInjector.isPublic(field) || !field.isAnnotationPresent(Gulp.Inject.class)) continue;
            field.setAccessible(true);
            injectableFields.add(field);
        }
        return Collections.unmodifiableList(injectableFields);
    }

    private static boolean isPublic(Field field) {
        return (field.getModifiers() & 1) != 0;
    }

    @Override
    public final Set<Type> requires() {
        HashSet<Type> types = new HashSet<Type>(this.injectableFields.size());
        for (Field field : this.injectableFields) {
            types.add(field.getGenericType());
        }
        return Collections.unmodifiableSet(types);
    }

    @Override
    public void inject(Type type, Object value) {
        for (Field field : this.injectableFields) {
            if (!field.getGenericType().equals(type)) continue;
            try {
                field.set(this.target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

