/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.kernel;

import com.azul.gulp.ProcessingException;
import com.azul.gulp.kernel.ExceptionHandler;
import com.azul.gulp.kernel.Kernel;
import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.nexus.NexusHandler;
import com.azul.gulp.nexus.NexusNormalizer;
import com.azul.gulp.nexus.NexusUnhandler;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

final class TypeDispatcher<T> {
    private final ExceptionHandler exceptionHandler;
    private final NexusNormalizers<T> normalizers;
    private final Handlers<T> handlers;
    private T inflight;
    private boolean handled;

    public TypeDispatcher(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        this.normalizers = new NexusNormalizers(exceptionHandler);
        this.handlers = new Handlers(exceptionHandler);
    }

    public final void init(Nexus ctx) {
        this.exceptionHandler.init(ctx);
        this.normalizers.init(ctx);
        this.handlers.init(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fire(Kernel engine, T event) {
        T normalized = this.normalizers.normalize(event);
        if (normalized != null) {
            this.startHandling(normalized);
            try {
                this.handlers.handle(normalized);
            }
            finally {
                boolean handled = this.endHandling(normalized);
                if (!handled) {
                    this.handlers.handleUnhandled(normalized);
                }
            }
        }
    }

    public final void addNormalizer(NexusNormalizer<T> normalizer) {
        this.normalizers.add(normalizer);
    }

    public final void removeNormalizer(NexusNormalizer<T> normalizer) {
        this.normalizers.removeHandler(normalizer);
    }

    public final void addHandler(NexusHandler<? super T> handler) {
        this.handlers.addHandler(handler);
    }

    public final void removeHandler(NexusHandler<? super T> handler) {
        this.handlers.removeHandler(handler);
    }

    public final boolean hasUnhandler() {
        return this.handlers.hasUnhandler();
    }

    public final void addUnhandler(NexusUnhandler<? super T> unhandler) {
        this.handlers.addUnhandler(unhandler);
    }

    public final void removeUnhandler(NexusUnhandler<? super T> unhandler) {
        this.handlers.removeUnhandler(unhandler);
    }

    public final void markHandled(T item) {
        if (this.inflight == item) {
            this.handled = true;
        }
    }

    private void startHandling(T item) {
        this.inflight = item;
        this.handled = false;
    }

    private boolean endHandling(T item) {
        if (this.inflight != item) {
            throw new IllegalStateException();
        }
        return this.handled;
    }

    public final void finish() throws ProcessingException {
        this.handlers.finish();
        this.normalizers.finish();
        this.exceptionHandler.finish();
    }

    private static final class Handlers<T> {
        private final ExceptionHandler exceptionHandler;
        private final ArrayList<NexusHandler<? super T>> handlers = new ArrayList(4);
        private List<NexusUnhandler<? super T>> unhandlers = null;
        private Nexus initContext = null;

        Handlers(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
        }

        void init(Nexus ctx) {
            for (NexusHandler<T> handler : this.handlers) {
                try {
                    handler.init(ctx);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handle(t);
                }
            }
        }

        void addHandler(NexusHandler<? super T> handler) {
            boolean modified = this.handlers.add(handler);
            if (modified && this.initContext != null) {
                try {
                    handler.init(this.initContext);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handle(t);
                }
            }
        }

        void removeHandler(NexusHandler<? super T> handler) {
            boolean modified = this.handlers.remove(handler);
            if (modified && this.initContext != null) {
                try {
                    handler.finish();
                }
                catch (Throwable t) {
                    this.exceptionHandler.handle(t);
                }
            }
        }

        void handle(T value) {
            for (NexusHandler<T> handler : this.handlers) {
                try {
                    handler.handle(value);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handle(t);
                }
            }
        }

        boolean hasUnhandler() {
            return this.unhandlers != null && !this.unhandlers.isEmpty();
        }

        void addUnhandler(NexusUnhandler<? super T> unhandler) {
            boolean modified;
            if (this.unhandlers == null) {
                this.unhandlers = new ArrayList<NexusUnhandler<? super T>>(4);
            }
            if ((modified = this.unhandlers.add(unhandler)) && this.initContext != null) {
                try {
                    unhandler.init(this.initContext);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handle(t);
                }
            }
        }

        void removeUnhandler(NexusUnhandler<? super T> unhandler) {
            if (this.unhandlers == null) {
                return;
            }
            boolean modified = this.unhandlers.remove(unhandler);
            if (modified && this.initContext != null) {
                try {
                    unhandler.finish();
                }
                catch (Throwable t) {
                    this.exceptionHandler.handle(t);
                }
            }
        }

        void handleUnhandled(T value) {
            if (this.unhandlers == null) {
                return;
            }
            for (NexusUnhandler<T> handler : this.unhandlers) {
                try {
                    handler.unhandle(value);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handle(t);
                }
            }
        }

        void finish() {
            for (NexusHandler<T> handler : this.handlers) {
                try {
                    handler.finish();
                }
                catch (Throwable t) {
                    this.exceptionHandler.handle(t);
                }
            }
        }
    }

    static final class NexusNormalizers<T> {
        private final ExceptionHandler exceptionHandler;
        private final ArrayList<NexusNormalizer<T>> normalizers = new ArrayList(4);
        private LinkedHashSet<NexusNormalizer<T>> orderedNormalizers = null;
        private int resetCount = 0;

        NexusNormalizers(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
        }

        void add(NexusNormalizer<T> normalizer) {
            this.normalizers.add(normalizer);
        }

        void removeHandler(NexusNormalizer<T> normalizer) {
            this.normalizers.remove(normalizer);
        }

        void init(Nexus ctx) throws ProcessingException {
            for (NexusNormalizer<T> normalizer : this.normalizers) {
                try {
                    normalizer.init(ctx);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handle(t);
                }
            }
        }

        T normalize(T value) throws ProcessingException {
            T priorValue;
            ++this.resetCount;
            if (this.resetCount == 100) {
                this.orderedNormalizers = null;
            }
            LinkedHashSet<NexusNormalizer> usedNormalizers = new LinkedHashSet<NexusNormalizer>(this.normalizers.size());
            LinkedHashSet<NexusNormalizer<T>> orderedNormalizers = this.orderedNormalizers != null ? this.orderedNormalizers : new LinkedHashSet<NexusNormalizer<T>>(this.normalizers);
            T normalizedValue = value;
            do {
                normalizedValue = priorValue = normalizedValue;
                for (NexusNormalizer nexusNormalizer : orderedNormalizers) {
                    if (usedNormalizers.contains(nexusNormalizer)) continue;
                    try {
                        T curInputValue = normalizedValue;
                        T curOutputValue = nexusNormalizer.normalize(curInputValue);
                        if (curInputValue != curOutputValue && !curInputValue.equals(curOutputValue)) {
                            usedNormalizers.add(nexusNormalizer);
                        }
                        if (curOutputValue == null) {
                            return null;
                        }
                        normalizedValue = curOutputValue;
                    }
                    catch (Throwable t) {
                        this.exceptionHandler.handle(t);
                    }
                }
            } while (!normalizedValue.equals(priorValue));
            if (this.orderedNormalizers == null) {
                this.orderedNormalizers = usedNormalizers;
                this.orderedNormalizers.addAll(this.normalizers);
            }
            return normalizedValue;
        }

        void finish() {
        }
    }
}

