/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.processorsupport;

import com.azul.gulp.processorsupport.ProcessorMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class ProcessorInspector<A extends Annotation> {
    public static <A extends Annotation> ProcessorInspector<A> make(final Class<A> annoClass) {
        return new ProcessorInspector<A>(){

            @Override
            protected Class<A> annotationClass() {
                return annoClass;
            }
        };
    }

    protected abstract Class<A> annotationClass();

    public final List<ProcessorMethod> methods(Object obj) {
        A anno;
        ArrayList<ProcessorMethod> processorMethods = new ArrayList<ProcessorMethod>(obj.getClass().getMethods().length);
        Class<A> annoClass = this.annotationClass();
        for (Method method : obj.getClass().getMethods()) {
            anno = method.getAnnotation(annoClass);
            if (anno == null) continue;
            method.setAccessible(true);
            processorMethods.add(new ProcessorMethod(obj, method));
        }
        for (Method method : obj.getClass().getDeclaredMethods()) {
            anno = method.getAnnotation(annoClass);
            if (anno == null || (method.getModifiers() & 1) != 0) continue;
            method.setAccessible(true);
            processorMethods.add(new ProcessorMethod(obj, method));
        }
        return processorMethods;
    }
}

