/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.sources;

import com.azul.gulp.Emitter;
import com.azul.gulp.ProcessingException;
import com.azul.gulp.Processor;
import com.azul.gulp.foundations.GulpLogBase;
import com.azul.gulp.foundations.GulpLogExtension;
import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.nexus.NexusEmitter;
import com.azul.gulp.nexus.NexusHandledMarker;
import com.azul.gulp.nexus.NexusHandler;
import com.azul.gulp.nexus.Plugin;
import com.azul.gulp.sources.Converter;
import com.azul.gulp.sources.PipelineConfiguration;
import com.azul.gulp.sources.Source;
import java.util.Collections;
import java.util.List;

public abstract class SourceBasedGulpLog<E extends GulpLogExtension<E>, S>
extends GulpLogBase<E> {
    private final SourceConverterPlugin<S> sourcePlugin;

    public SourceBasedGulpLog(Source<S> source) {
        this.sourcePlugin = new SourceConverterPlugin<S>(source);
    }

    protected SourceBasedGulpLog(Source<S> source, PipelineConfiguration normalizers) {
        super(normalizers);
        this.sourcePlugin = new SourceConverterPlugin<S>(source);
    }

    @Override
    public final E prefetch() {
        try {
            ((Source)this.source()).prefetch();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
        SourceBasedGulpLog casted = this;
        return (E)casted;
    }

    protected abstract E createOffspring(Source<S> var1);

    @Override
    protected abstract E createOffspring(PipelineConfiguration var1);

    protected final <T extends Source<S>> T source() {
        Source casted = this.sourcePlugin.source;
        return (T)casted;
    }

    protected final Class<S> coreType() {
        return ((Source)this.source()).coreType();
    }

    @Override
    protected final List<Class<?>> coreTypes() {
        return Collections.singletonList(this.coreType());
    }

    @Override
    protected List<Plugin> additionalPlugins() {
        return Collections.singletonList(this.sourcePlugin);
    }

    @Override
    protected void run(Nexus engine) throws Exception {
        final NexusEmitter<S> emitter = engine.getEmitter(this.coreType());
        ((Source)this.source()).forEach(new Processor<S>(){

            @Override
            public final void process(S input) {
                emitter.fire(input);
            }
        });
    }

    private static final class SourceConverterPlugin<T>
    extends Plugin {
        final Source<T> source;

        SourceConverterPlugin(Source<T> source) {
            this.source = source;
        }

        @Override
        public <V> boolean handleEventRequest(Nexus engine, final Class<V> requiredType) throws Exception {
            final Class<T> coreType = this.source.coreType();
            final Converter<T, V> converter = this.source.converterFor(requiredType);
            if (converter == null) {
                return false;
            }
            engine.handle(coreType, new NexusHandler<T>(){
                private NexusHandledMarker<T> marker;
                private Emitter<V> emitter;

                @Override
                public void init(Nexus engine) throws Exception {
                    converter.init(engine);
                    this.marker = engine.getMarker(coreType);
                    NexusEmitter nexusEmitter = engine.getEmitter(requiredType);
                    this.emitter = nexusEmitter::fire;
                }

                @Override
                public final void handle(T input) throws Exception {
                    if (this.marker.isActivated()) {
                        Emitter<Object> markingEmitter = output -> {
                            this.marker.mark(input);
                            this.emitter.fire(output);
                        };
                        converter.convert(input, markingEmitter);
                    } else {
                        converter.convert(input, this.emitter);
                    }
                }
            });
            return true;
        }
    }
}

