/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.text;

import com.azul.gulp.text.RegexMatcher;
import java.util.regex.Pattern;

public final class Line {
    public final int num;
    public final String contents;
    public final String originalContents;

    public Line(int num, String contents) {
        this(num, contents, contents);
    }

    public Line(int num, String contents, String originalContents) {
        this.num = num;
        this.contents = contents;
        this.originalContents = originalContents;
    }

    public Line(Line baseLine, String contents) {
        this.num = baseLine.num;
        this.originalContents = baseLine.originalContents;
        this.contents = contents;
    }

    public final int length() {
        return this.contents.length();
    }

    public final char charAt(int i) {
        return this.contents.charAt(i);
    }

    public final String[] split(String regex) {
        return this.contents.split(regex);
    }

    public final String[] split(String regex, int limit) {
        return this.contents.split(regex, limit);
    }

    public final int indexOf(char ch) {
        return this.contents.indexOf(ch);
    }

    public final int indexOf(char ch, int fromIndex) {
        return this.contents.indexOf(ch, fromIndex);
    }

    public final int indexOf(String substr) {
        return this.contents.indexOf(substr);
    }

    public final int indexOf(String substr, int fromIndex) {
        return this.contents.indexOf(substr, fromIndex);
    }

    public final int lastIndexOf(char ch) {
        return this.contents.lastIndexOf(ch);
    }

    public final int lastIndexOf(char ch, int fromIndex) {
        return this.contents.lastIndexOf(ch, fromIndex);
    }

    public final int lastIndexOf(String substr) {
        return this.contents.lastIndexOf(substr);
    }

    public final int lastIndexOf(String substr, int fromIndex) {
        return this.contents.lastIndexOf(substr, fromIndex);
    }

    public final String before(int needle) {
        int index = this.contents.indexOf(needle);
        if (index == -1) {
            return this.contents;
        }
        return this.contents.substring(0, index);
    }

    public final String substring(int begin) {
        return this.contents.substring(begin);
    }

    public final Line subLine(int begin) {
        return new Line(this.num, this.substring(begin), this.originalContents);
    }

    public final String substring(int begin, int end) {
        return this.contents.substring(begin, end);
    }

    public final Line subLine(int begin, int end) {
        return new Line(this.num, this.substring(begin, end), this.originalContents);
    }

    public final Line trim() {
        return new Line(this.num, this.contents.trim(), this.originalContents);
    }

    public final boolean startsWith(String value) {
        return this.contents.startsWith(value);
    }

    public final boolean endsWith(String value) {
        return this.contents.endsWith(value);
    }

    public final boolean contains(String value) {
        return this.contents.contains(value);
    }

    public final boolean contains(char ch) {
        for (int i = 0; i < this.contents.length(); ++i) {
            if (this.contents.charAt(i) != ch) continue;
            return true;
        }
        return false;
    }

    public final Line replace(String subStr, String replacementStr) {
        return new Line(this.num, this.contents.replace(subStr, replacementStr), this.originalContents);
    }

    public final Line strip(Pattern regex) {
        return this.replace(regex, "");
    }

    public final Line replace(Pattern regex, String replacement) {
        RegexMatcher matcher = this.match(regex);
        if (!matcher.matches()) {
            return this;
        }
        if (matcher.groupCount() != 1) {
            throw new IllegalArgumentException();
        }
        int start = matcher.groupStart(1);
        int end = matcher.groupEnd(1);
        String prefix = this.contents.substring(0, start);
        String suffix = this.contents.substring(end);
        Line normalizedLine = new Line(this.num, prefix + replacement + suffix, this.originalContents);
        return normalizedLine;
    }

    public final RegexMatcher match(String regex) {
        return this.match(Pattern.compile(regex));
    }

    public final RegexMatcher match(Pattern regex, boolean matchOriginal) {
        return RegexMatcher.match(regex, matchOriginal ? this.originalContents : this.contents);
    }

    public final RegexMatcher match(Pattern regex) {
        return RegexMatcher.match(regex, this.contents);
    }

    public final RegexMatcher matchOriginal(Pattern regex) {
        return RegexMatcher.match(regex, this.originalContents);
    }

    public final boolean equals(String str) {
        return this.contents.equals(str);
    }

    public final int hashCode() {
        return this.contents.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return this.equals(str);
        }
        if (!(obj instanceof Line)) {
            return false;
        }
        Line that = (Line)obj;
        return this.num == that.num && this.contents.equals(that.contents);
    }

    public final char[] toCharArray() {
        return this.contents.toCharArray();
    }

    public final String toString() {
        return String.format("%4d: %s ----- %s", this.num, this.contents, this.originalContents);
    }
}

