/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.text;

import com.azul.gulp.Normalizer;
import com.azul.gulp.inject.InjectionContext;
import com.azul.gulp.text.Line;
import com.azul.gulp.text.LineNormalizer;
import com.azul.gulp.text.support.InjectableNormalizer;

public final class LineNormalizers {
    private LineNormalizers() {
    }

    public static LineNormalizer stripLeading(final char ch) {
        return new LineNormalizer(){

            @Override
            public final String normalize(String line) {
                for (int i = 0; i < line.length(); ++i) {
                    if (line.charAt(i) == ch) continue;
                    return line.substring(i);
                }
                return line;
            }
        };
    }

    public static LineNormalizer stripLeading(final int numChars) {
        return new LineNormalizer(){

            @Override
            public final String normalize(String line) {
                if (line.length() < numChars) {
                    return line;
                }
                return line.substring(numChars);
            }
        };
    }

    public static Normalizer<Line> toGenericNormalizer(final LineNormalizer lineNormalizer) {
        return new InjectableNormalizer<Line>(){

            @Override
            public final void onInject(InjectionContext ctx) {
                ctx.inject(lineNormalizer);
            }

            @Override
            public final Line normalize(Line in) throws Exception {
                String normalizedContents = lineNormalizer.normalize(in.contents);
                return new Line(in.num, normalizedContents, in.originalContents);
            }
        };
    }
}

