/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.text;

import com.azul.gulp.Emitter;
import com.azul.gulp.LogProcessingException;
import com.azul.gulp.Processor;
import com.azul.gulp.io.IoProvider;
import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.sources.Converter;
import com.azul.gulp.sources.Source;
import com.azul.gulp.text.GulpText;
import com.azul.gulp.text.Line;
import com.azul.gulp.text.LineMatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;

public final class LineSource
extends Source<Line> {
    private final Iterable<? extends IoProvider<Reader>> readerProviders;

    public LineSource(File file) {
        this(() -> new FileReader(file));
    }

    public LineSource(URL url) {
        this(() -> new InputStreamReader(url.openStream()));
    }

    public LineSource(String content) {
        this(() -> new StringReader(content));
    }

    public LineSource(IoProvider<Reader> readerProvider) {
        this(Collections.singleton(readerProvider));
    }

    public LineSource(File ... files) {
        this(LineSource.asProviders(files));
    }

    private static Iterable<? extends IoProvider<Reader>> asProviders(File ... files) {
        ArrayList<IoProvider<Reader>> readerProviders = new ArrayList<IoProvider<Reader>>(files.length);
        for (File file : files) {
            readerProviders.add(() -> new FileReader(file));
        }
        return readerProviders;
    }

    public LineSource(Iterable<? extends IoProvider<Reader>> readerProviders) {
        this.readerProviders = readerProviders;
    }

    @Override
    public final Class<Line> coreType() {
        return Line.class;
    }

    @Override
    public <U> Converter<Line, U> converterFor(Class<U> type) {
        GulpText.LineMatchers lineMatchersAnno = type.getAnnotation(GulpText.LineMatchers.class);
        GulpText.LineMatcher lineMatcherAnno = type.getAnnotation(GulpText.LineMatcher.class);
        if (lineMatchersAnno == null && lineMatcherAnno == null) {
            return null;
        }
        if (lineMatchersAnno != null) {
            if (lineMatcherAnno != null) {
                throw new IllegalStateException("Should not specify both @LineMatchers and @LineMatcher");
            }
            LineMatcher<U> lineMatcher = GulpText.makeMatcherFrom(type, lineMatchersAnno);
            return new LineMatcherConverterAdapter<U>(type, lineMatcher);
        }
        LineMatcher<U> lineMatcher = GulpText.makeMatcherFrom(type, lineMatcherAnno);
        return new LineMatcherConverterAdapter<U>(type, lineMatcher);
    }

    @Override
    protected final void forEachImpl(Processor<? super Line> processor) {
        for (IoProvider<Reader> ioProvider : this.readerProviders) {
            this.forEach(ioProvider, processor);
        }
    }

    protected final void forEach(IoProvider<Reader> readerProvider, Processor<? super Line> processor) {
        try (BufferedReader reader = new BufferedReader(readerProvider.open());){
            int curLineNumber = 0;
            String line = reader.readLine();
            while (line != null) {
                try {
                    processor.process(new Line(++curLineNumber, line, line));
                }
                catch (Exception e) {
                    throw new LogProcessingException(e);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new LogProcessingException(e);
        }
    }

    private static final class LineMatcherConverterAdapter<T>
    extends Converter<Line, T> {
        private final Class<T> type;
        private final LineMatcher<T> matcher;

        public LineMatcherConverterAdapter(Class<T> type, LineMatcher<T> matcher) {
            this.type = type;
            this.matcher = matcher;
        }

        @Override
        public final void init(Nexus ctx) {
            ctx.inject(this.matcher);
        }

        @Override
        public final void convert(Line input, Emitter<T> emitter) throws Exception {
            this.matcher.process(input, emitter);
        }
    }
}

