/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.text.support;

import com.azul.gulp.Emitter;
import com.azul.gulp.inject.InjectionAware;
import com.azul.gulp.inject.InjectionContext;
import com.azul.gulp.text.Line;
import com.azul.gulp.text.LineMatcher;
import com.azul.gulp.text.support.ExceptionHelper;
import java.util.Arrays;
import java.util.List;

public final class CompositeLineMatcher<T>
implements LineMatcher<T>,
InjectionAware {
    private final List<? extends LineMatcher<T>> matchers;

    @SafeVarargs
    public CompositeLineMatcher(LineMatcher<T> ... matchers) {
        this(Arrays.asList(matchers));
    }

    public CompositeLineMatcher(List<? extends LineMatcher<T>> matchers) {
        this.matchers = matchers;
    }

    @Override
    public final void onInject(InjectionContext ctx) {
        for (LineMatcher<T> matcher : this.matchers) {
            ctx.inject(matcher);
        }
    }

    @Override
    public final void process(Line line, Emitter<T> emitter) throws Exception {
        TrackingEmitter<T> trackingEmitter = new TrackingEmitter<T>(emitter);
        ExceptionHelper exHelper = new ExceptionHelper();
        for (LineMatcher<T> matcher : this.matchers) {
            try {
                matcher.process(line, emitter);
            }
            catch (Exception e) {
                exHelper.recordException(e);
            }
        }
        if (!trackingEmitter.fired()) {
            exHelper.rethrow();
        }
    }

    static final class TrackingEmitter<T>
    implements Emitter<T> {
        private final Emitter<T> wrappedEmitter;
        private boolean fired = false;

        public TrackingEmitter(Emitter<T> emitter) {
            this.wrappedEmitter = emitter;
        }

        public void reset() {
            this.fired = false;
        }

        @Override
        public void fire(T value) {
            this.wrappedEmitter.fire(value);
            this.fired = true;
        }

        public boolean fired() {
            return this.fired;
        }
    }
}

