/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.compile;

import com.azul.jvm.codeprofile.CodeProfileId;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompilationTier;
import com.azul.jvm.compile.CompilationTrigger;
import com.azul.jvm.compile.OptLevel;
import com.azul.jvm.compile.StashFlavor;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.method.PersistentMethodId;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

public class Compilation {
    private final CompilationId id;
    PersistentMethodId methodId = PersistentMethodId.INVALID;
    String methodName;
    final Set<PersistentKlassId> loadedKlasses;
    final Set<PersistentKlassId> linkedKlasses;
    final Set<PersistentKlassId> initializedKlasses;
    final Set<PersistentKlassId> hierarchyKlasses;
    final Set<PersistentMethodId> inlinedMethods;
    final Set<CodeProfileId> codeProfiles;
    CompilationTier tier;
    Integer osrBci;
    CompilationTrigger trigger;
    StashFlavor stashFlavor;
    OptLevel optLevel;
    String result;
    long blobSize;
    Duration cpuTime;
    Duration wallTime;
    Duration waitTime;

    public Compilation(CompilationId id) {
        this.id = id;
        this.loadedKlasses = new LinkedHashSet<PersistentKlassId>();
        this.linkedKlasses = new LinkedHashSet<PersistentKlassId>();
        this.initializedKlasses = new LinkedHashSet<PersistentKlassId>();
        this.inlinedMethods = new LinkedHashSet<PersistentMethodId>();
        this.hierarchyKlasses = new LinkedHashSet<PersistentKlassId>();
        this.codeProfiles = new LinkedHashSet<CodeProfileId>();
    }

    public CompilationId id() {
        return this.id;
    }

    public CompilationTier tier() {
        return this.tier;
    }

    public CompilationTrigger trigger() {
        return this.trigger;
    }

    public StashFlavor stashFlavor() {
        return this.stashFlavor;
    }

    public OptLevel optLevel() {
        return this.optLevel;
    }

    public boolean isOsr() {
        return this.osrBci != null;
    }

    public Integer osrBci() {
        return this.osrBci;
    }

    public PersistentMethodId methodId() {
        return this.methodId;
    }

    public String methodName() {
        return this.methodName;
    }

    public Stream<PersistentKlassId> loadedKlasses() {
        return this.loadedKlasses.stream();
    }

    public Stream<PersistentKlassId> linkedKlasses() {
        return this.linkedKlasses.stream();
    }

    public Stream<PersistentKlassId> hierarchyKlasses() {
        return this.hierarchyKlasses.stream();
    }

    public Stream<PersistentKlassId> initializedKlasses() {
        return this.initializedKlasses.stream();
    }

    public Stream<PersistentMethodId> inlinedMethods() {
        return this.inlinedMethods.stream();
    }

    public Stream<CodeProfileId> codeProfiles() {
        return this.codeProfiles.stream();
    }

    public String result() {
        return this.result;
    }

    public boolean isSuccess() {
        return "success".equals(this.result);
    }

    public String failureReason() {
        return this.isSuccess() ? null : this.result;
    }

    public long blobSize() {
        return this.blobSize;
    }

    public Duration cpuTime() {
        return this.cpuTime;
    }

    public Duration wallTime() {
        return this.wallTime;
    }

    public Duration waitTime() {
        return this.waitTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Compilation:");
        sb.append(" tier: ").append((Object)this.tier);
        if (this.osrBci != null) {
            sb.append(" OSR BCI: ").append(this.osrBci);
        }
        if (this.trigger != null && this.trigger != CompilationTrigger.UNKNOWN) {
            sb.append(" trigger: ").append((Object)this.trigger);
        }
        sb.append(" result: ").append(this.result);
        if (this.blobSize != 0L) {
            sb.append(" blobSize: ").append(this.blobSize);
        }
        return sb.toString();
    }
}

