/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.compile;

import com.azul.gulp.text.GulpText;
import com.azul.jvm.MemoryAddress;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompilationTier;
import com.azul.jvm.compile.CompileData;
import com.azul.jvm.compile.CompileRelated;
import com.azul.jvm.compile.CompilerId;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.zing.console.matchers.CompilationInstallationLineMatcher;
import com.azul.zing.console.matchers.PreludeCompilationInstallationLineMatcher;
import com.azul.zing.console.matchers.PreludeCompilationInstallationLineMatcherV2;
import com.azul.zing.console.matchers.PreludeCompilationInstallationLineMatcherV3;
import com.azul.zing.console.matchers.ZephyrCompileInstalledLineMatcher;
import java.time.Duration;

@GulpText.LineMatchers(value={@GulpText.LineMatcher(value=CompilationInstallationLineMatcher.class), @GulpText.LineMatcher(value=PreludeCompilationInstallationLineMatcher.class), @GulpText.LineMatcher(value=PreludeCompilationInstallationLineMatcherV2.class), @GulpText.LineMatcher(value=PreludeCompilationInstallationLineMatcherV3.class), @GulpText.LineMatcher(value=ZephyrCompileInstalledLineMatcher.class)})
public final class CompileInstalled
extends CompileRelated {
    public final MemoryAddress address;
    public final int size;
    public final Boolean hitStash;
    public final Duration waitTime;
    public final Duration cpuCompileTime;
    public final Duration wallclockCompileTime;

    public CompileInstalled(CompilationId compileId, CompilerId compilerId, CompilationTier tier, MemoryAddress address, int size) {
        this(compileId, compilerId, tier, "?", address, size, null, null, null, null, null, null, null, null, null, null);
    }

    public CompileInstalled(CompilationId compileId, CompilerId compilerId, CompilationTier tier, String methodName, MemoryAddress address, int size, double compileTimeMs) {
        this(compileId, compilerId, tier, methodName, address, size, null, null, null, CompileInstalled.ofFractMillis(compileTimeMs), null, null, null, null, null, null);
    }

    public CompileInstalled(CompilationId compileId, CompilerId compilerId, CompilationTier tier, String methodName, MemoryAddress address, int size, double waitTime, double compileTimeMs) {
        this(compileId, compilerId, tier, methodName, address, size, null, CompileInstalled.ofFractMillis(waitTime), null, CompileInstalled.ofFractMillis(compileTimeMs), null, null, null, null, null, null);
    }

    public CompileInstalled(CompilationId compileId, CompilerId compilerId, CompilationTier tier, String methodName, MemoryAddress address, int size, boolean hitStash, double waitTime, double cpuCompileTime, double wallclockCompileTime) {
        this(compileId, compilerId, tier, methodName, address, size, hitStash, CompileInstalled.ofFractMillis(waitTime), CompileInstalled.ofFractMillis(cpuCompileTime), CompileInstalled.ofFractMillis(wallclockCompileTime), null, null, null, null, null, null);
    }

    private static Duration ofFractMillis(double ms) {
        return Duration.ofNanos((long)(1000000.0 * ms));
    }

    public CompileInstalled(CompilationId compileId, CompilerId compilerId, CompilationTier tier, String methodName, MemoryAddress address, int size, Boolean hitStash, Duration waitTime, Duration cpuCompileTime, Duration wallclockCompileTime, Long methodId, PersistentMethodId persistentMethodId, Long protocolId, Integer klassId, PersistentKlassId persistentKlassId, Integer generation) {
        super(compileId, false, false, false, false, false, compilerId, tier, methodName, null, null, generation, null, null, null, null, null, methodId, persistentMethodId, protocolId, klassId, persistentKlassId, null, null);
        this.address = address;
        this.size = size;
        this.hitStash = hitStash;
        this.waitTime = waitTime;
        this.cpuCompileTime = cpuCompileTime;
        this.wallclockCompileTime = wallclockCompileTime;
    }

    public CompileInstalled(CompileData data, MemoryAddress blobAddress, Integer blobSize, Boolean hitStash, Duration waitTime, Duration cpuCompileTime, Duration wallclockCompileTime) {
        super(data);
        this.address = blobAddress;
        this.size = blobSize;
        this.hitStash = hitStash;
        this.waitTime = waitTime;
        this.cpuCompileTime = cpuCompileTime;
        this.wallclockCompileTime = wallclockCompileTime;
    }

    @Override
    public String toString() {
        String str = "Installed: " + this.compileId + " " + this.compilerId;
        if (this.waitTime != null) {
            str = str + String.format(" wait time=%dms", this.waitTime.toMillis());
        }
        if (this.cpuCompileTime != null) {
            str = str + String.format(" compile time=%dms / %dms", this.cpuCompileTime.toMillis(), this.wallclockCompileTime.toMillis());
        } else if (this.wallclockCompileTime != null) {
            str = str + String.format(" compile time=%dms", this.wallclockCompileTime.toMillis());
        }
        return str;
    }
}

