/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.deopt;

import com.azul.jvm.Opcode;
import com.azul.jvm.method.ByteCodeIndex;
import com.azul.jvm.method.PersistentMethodId;
import java.util.Objects;

public class StackFrame {
    protected PersistentMethodId methodId;
    protected String methodName;
    protected ByteCodeIndex bci;
    protected Opcode opcode;

    protected StackFrame() {
    }

    public StackFrame(PersistentMethodId methodId, String methodName, ByteCodeIndex bci, Opcode opcode) {
        if (methodId == null && methodName == null) {
            throw new NullPointerException("method and methodId can not both be null");
        }
        this.methodId = methodId;
        this.methodName = methodName;
        this.bci = Objects.requireNonNull(bci, "bci");
        this.opcode = opcode;
    }

    public PersistentMethodId methodId() {
        return this.methodId;
    }

    public String methodName() {
        return this.methodName;
    }

    public ByteCodeIndex bci() {
        return this.bci;
    }

    public Opcode opcode() {
        return this.opcode;
    }
}

