/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.deopts;

import com.azul.gulp.text.GulpText;
import com.azul.java.MethodId;
import com.azul.jvm.MemoryAddress;
import com.azul.jvm.Opcode;
import com.azul.jvm.ThreadId;
import com.azul.jvm.VmEventBase;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.deopt.DeoptAction;
import com.azul.jvm.deopt.DeoptReason;
import com.azul.jvm.deopt.UncommonTrapId;
import com.azul.jvm.method.ByteCodeIndex;
import com.azul.zing.console.matchers.HighlanderUncommonTrapLineMatcher;
import com.azul.zing.console.matchers.UncommonTrap202006LineMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@GulpText.LineMatchers(value={@GulpText.LineMatcher(value=HighlanderUncommonTrapLineMatcher.class), @GulpText.LineMatcher(value=UncommonTrap202006LineMatcher.class)})
public final class UncommonTrap
extends VmEventBase {
    public final UncommonTrapId id;
    public final MethodId method;
    public final MemoryAddress address;
    public final ThreadId thread;
    public final String reasonStr;
    public final DeoptReason reason;
    public final CompilationId compileId;
    public final DeoptAction action;
    public final List<Repack> repacks;

    public UncommonTrap(int id, MethodId method, MemoryAddress address, ThreadId thread, String reason, CompilationId compileId, DeoptAction action, List<Repack> repacks) {
        this.id = UncommonTrapId.of(id);
        this.method = method;
        this.address = address;
        this.thread = thread;
        this.reasonStr = reason;
        this.reason = DeoptReason.fromVmNameOrUnknown(reason);
        this.compileId = compileId;
        this.action = action;
        this.repacks = Collections.unmodifiableList(repacks);
    }

    public final TrapKey key() {
        return new TrapKey(this.compileId, this.method, this.repacks.get((int)0).bci, this.reason);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.method, this.address, this.reason, this.thread, this.compileId});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UncommonTrap)) {
            return false;
        }
        UncommonTrap that = (UncommonTrap)obj;
        return this.compileId == that.compileId && this.method.equals(that.method) && Objects.equals(this.address, that.address) && this.reason.equals((Object)that.reason) && this.thread == that.thread;
    }

    public String toString(boolean detailed) {
        if (detailed) {
            return this.toDetailedString();
        }
        return this.toString();
    }

    public String toDetailedString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toString()).append('\n');
        for (Repack repack : this.repacks) {
            builder.append('\t').append(repack.toString()).append('\n');
        }
        return builder.toString();
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.method.name.length() + 30);
        builder.append("Uncommon Trap: ");
        builder.append(this.id);
        builder.append(' ');
        builder.append(this.method);
        builder.append(' ');
        builder.append("thread=").append(this.thread);
        builder.append(' ');
        builder.append("reason=").append(this.reason.vmName);
        builder.append(' ');
        builder.append("compile_id=").append(this.compileId);
        if (this.action != null) {
            builder.append(" action=").append((Object)this.action);
        }
        return builder.toString();
    }

    public static final class Repack {
        public final String method;
        public final ByteCodeIndex bci;
        public final Opcode opcode;

        public Repack(String method, int bci, int opcode) {
            this.method = method;
            this.bci = ByteCodeIndex.of(bci);
            this.opcode = Opcode.byCode(opcode);
        }

        public Repack(String method, int bci, Opcode opcode) {
            this.method = method;
            this.bci = ByteCodeIndex.of(bci);
            this.opcode = opcode;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.method.length() + 30);
            builder.append("Repack: ");
            builder.append(this.method).append(" @ ").append(this.bci);
            builder.append("  bytecode(").append((Object)this.opcode).append(')');
            return builder.toString();
        }
    }

    public static final class TrapKey {
        public final CompilationId compileId;
        public final MethodId method;
        public final ByteCodeIndex topBci;
        public final DeoptReason reason;

        public TrapKey(CompilationId compileId, MethodId method, ByteCodeIndex topBci, DeoptReason reason) {
            this.compileId = compileId;
            this.method = method;
            this.topBci = topBci;
            this.reason = reason;
        }

        public final boolean equals(Object obj) {
            if (!(obj instanceof TrapKey)) {
                return false;
            }
            TrapKey that = (TrapKey)obj;
            return Objects.equals(this.compileId, that.compileId) && this.topBci.equals(that.topBci) && this.reason.equals((Object)that.reason);
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.compileId, this.topBci, this.reason});
        }

        public final String toString() {
            return this.compileId + " " + this.reason + " @ " + this.method + " - bci: " + this.topBci;
        }
    }
}

