/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.klass;

import com.azul.jvm.klass.Klass;
import com.azul.jvm.klass.KlassKind;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoaderId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KlassBuilder
extends Klass {
    private final List<PendingArray> pendingArrays = new ArrayList<PendingArray>();

    public KlassBuilder(PersistentKlassId id) {
        super(id);
    }

    public KlassBuilder setPrevId(PersistentKlassId prevId) {
        this.prevId = prevId;
        return this;
    }

    public KlassBuilder setDefiningLoaderId(KlassLoaderId loaderId) {
        this.definingLoaderId = loaderId;
        return this;
    }

    public KlassBuilder setInitiatingLoaderId(KlassLoaderId loaderId) {
        this.initiatingLoaderId = loaderId;
        return this;
    }

    public KlassBuilder setKind(KlassKind kind) {
        this.kind = kind;
        return this;
    }

    public KlassBuilder setName(String name) {
        this.name = Objects.requireNonNull(name, "name");
        return this;
    }

    public KlassBuilder processPendingArrays() {
        for (PendingArray pendingArray : this.pendingArrays) {
            KlassBuilder.fillArray(pendingArray.arrayBuilder, this, pendingArray.dimension);
            pendingArray.arrayBuilder.processPendingArrays();
        }
        return this;
    }

    public static void fillArray(KlassBuilder arrayBuilder, Klass elementKlass, int dimension) {
        Objects.requireNonNull(arrayBuilder, "arrayBuilder");
        Objects.requireNonNull(elementKlass, "elementKlass");
        arrayBuilder.setName(KlassBuilder.makeArrayKlassName(elementKlass.getName(), dimension));
        arrayBuilder.setDefiningLoaderId(elementKlass.getDefiningLoaderId());
    }

    private static String makeArrayKlassName(String elementKlassName, int dimension) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dimension; ++i) {
            sb.append('[');
        }
        return sb.append(elementKlassName).toString();
    }

    public void addPendingArray(KlassBuilder arrayBuilder, int dimension) {
        this.pendingArrays.add(new PendingArray(arrayBuilder, dimension));
    }

    private final class PendingArray {
        private final KlassBuilder arrayBuilder;
        private final int dimension;

        public PendingArray(KlassBuilder arrayBuilder, int dimension) {
            this.arrayBuilder = Objects.requireNonNull(arrayBuilder, "arrayBuilder");
            this.dimension = dimension;
        }

        public String toString() {
            return "PendingArray{array=" + this.arrayBuilder + ", dimension=" + this.dimension + "}";
        }
    }
}

