/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.klass;

import java.util.ArrayList;
import java.util.List;

public final class PersistentKlassId {
    private static final int INVALID_ID = 0;
    public static final PersistentKlassId INVALID = new PersistentKlassId(0);
    private final int id;

    private PersistentKlassId(int id) {
        this.id = id;
    }

    public static PersistentKlassId of(int id) {
        return new PersistentKlassId(id);
    }

    public static List<PersistentKlassId> listOf(int ... ids) {
        ArrayList<PersistentKlassId> result = new ArrayList<PersistentKlassId>();
        for (int id : ids) {
            result.add(PersistentKlassId.of(id));
        }
        return result;
    }

    public int intValue() {
        return this.id;
    }

    public boolean isValid() {
        return this.id != 0;
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public int hashCode() {
        return Integer.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        return obj instanceof PersistentKlassId && ((PersistentKlassId)obj).id == this.id;
    }
}

