/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.method;

import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.method.MethodFullName;
import com.azul.jvm.method.MethodSignature;
import com.azul.jvm.method.MethodUniqueness;
import com.azul.jvm.method.PersistentMethodId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class Method {
    private final PersistentMethodId id;
    final List<MethodUniqueness> methodUniqueness;
    String klassName;
    PersistentKlassId klassId = PersistentKlassId.INVALID;
    String name;
    MethodSignature signature;
    int size;

    public Method(PersistentMethodId id) {
        this.id = id;
        this.methodUniqueness = new ArrayList<MethodUniqueness>();
    }

    public PersistentMethodId id() {
        return this.id;
    }

    public String klassName() {
        return this.klassName;
    }

    public PersistentKlassId klassId() {
        return this.klassId;
    }

    public String name() {
        return this.name;
    }

    public MethodSignature signature() {
        return this.signature;
    }

    public String nameAndSignature() {
        return this.name + " " + this.signature;
    }

    public MethodFullName fullName() {
        return MethodFullName.of(this.klassName, this.name, this.signature);
    }

    public int size() {
        return this.size;
    }

    public Stream<MethodUniqueness> methodUniqueness() {
        return this.methodUniqueness.stream();
    }

    public String toString() {
        return "Method: " + this.nameAndSignature();
    }
}

