/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.method;

import java.util.ArrayList;
import java.util.List;

public final class PersistentMethodId {
    private static final int INVALID_ID = 0;
    public static final PersistentMethodId INVALID = new PersistentMethodId(0L);
    private final long id;

    private PersistentMethodId(long id) {
        this.id = id;
    }

    public static PersistentMethodId of(long id) {
        return new PersistentMethodId(id);
    }

    public static List<PersistentMethodId> listOf(long ... ids) {
        ArrayList<PersistentMethodId> result = new ArrayList<PersistentMethodId>();
        for (long id : ids) {
            result.add(PersistentMethodId.of(id));
        }
        return result;
    }

    public long longValue() {
        return this.id;
    }

    public boolean isValid() {
        return this.id != 0L;
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public String toString() {
        return Long.toString(this.id);
    }

    public boolean equals(Object o) {
        return o instanceof PersistentMethodId && ((PersistentMethodId)o).id == this.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }
}

