/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.time;

import com.azul.jvm.time.EpochTime;
import com.azul.jvm.time.VmTime;
import java.util.TimeZone;

public final class TimeTranslator {
    private final VmTime vmTime;
    private final EpochTime epochTime;
    private final TimeZone timeZone;

    public TimeTranslator(VmTime vmTime, long epochTime) {
        this(vmTime, EpochTime.fromMillis(epochTime));
    }

    public TimeTranslator(VmTime vmTime, EpochTime epochTime) {
        this(vmTime, epochTime, epochTime.timeZone);
    }

    public TimeTranslator(VmTime vmTime, EpochTime epochTime, TimeZone timeZone) {
        this.vmTime = vmTime;
        this.epochTime = epochTime;
        this.timeZone = timeZone;
    }

    private VmTime toVmTime(long epochTimeNs) {
        long deltaNs = epochTimeNs - this.epochTime.nanos;
        return VmTime.fromNanos(this.vmTime.nanosElapsed + deltaNs);
    }

    public final VmTime toVmTime(EpochTime epochTime) {
        return this.toVmTime(epochTime.nanos);
    }

    public final EpochTime toEpochTime(long nanosSinceStart) {
        long deltaNs = nanosSinceStart - this.vmTime.nanosElapsed;
        long epochTimeNs = this.epochTime.nanos + deltaNs;
        if (this.timeZone == null) {
            return EpochTime.fromNanos(epochTimeNs);
        }
        return EpochTime.fromNanos(epochTimeNs, this.timeZone);
    }

    public final EpochTime toEpochTime(VmTime vmTime) {
        return this.toEpochTime(vmTime.nanosElapsed);
    }

    public String toString() {
        return "epoch: " + this.epochTime + " ->  vm time: " + this.vmTime;
    }
}

