/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.time;

import com.azul.jvm.time.BaseTime;
import com.azul.jvm.time.EpochTime;
import java.util.concurrent.TimeUnit;

public final class VmTime
implements BaseTime<VmTime> {
    public static final VmTime ZERO;
    public static final VmTime MIN;
    public static final VmTime MAX;
    public final long nanosElapsed;

    public static VmTime min(VmTime lhs, VmTime rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return lhs.compareTo(rhs) <= 0 ? lhs : rhs;
    }

    public static VmTime max(VmTime lhs, VmTime rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return lhs.compareTo(rhs) >= 0 ? lhs : rhs;
    }

    public static VmTime fromNanos(long nanos) {
        return new VmTime(nanos);
    }

    public static VmTime fromSeconds(long seconds) {
        return VmTime.from(seconds, TimeUnit.SECONDS);
    }

    public static VmTime fromMillis(long millis) {
        return VmTime.from(millis, TimeUnit.MILLISECONDS);
    }

    public static VmTime from(long count, TimeUnit unit) {
        return new VmTime(TimeUnit.NANOSECONDS.convert(count, unit));
    }

    public static VmTime fromSecondsString(String str) {
        String[] prefixParts = str.split("\\.");
        if (prefixParts.length != 2) {
            throw new IllegalArgumentException();
        }
        int prefixSecs = Integer.parseInt(prefixParts[0], 10);
        if (prefixParts[1].length() < 3) {
            throw new IllegalArgumentException();
        }
        prefixParts[1] = prefixParts[1].substring(0, 3);
        int prefixMillis = Integer.parseInt(prefixParts[1], 10);
        int totalMillis = 1000 * prefixSecs + prefixMillis;
        return VmTime.fromMillis(totalMillis);
    }

    public static VmTime compute(EpochTime startTime, EpochTime curTime) {
        return VmTime.fromNanos(curTime.nanos - startTime.nanos);
    }

    private VmTime(long nanosElapsed) {
        this.nanosElapsed = nanosElapsed;
    }

    public boolean within(VmTime lowerTime, VmTime upperTime) {
        return this.compareTo(lowerTime) >= 0 && this.compareTo(upperTime) <= 0;
    }

    @Override
    public final VmTime add(long duration, TimeUnit unit) {
        long inc = TimeUnit.NANOSECONDS.convert(duration, unit);
        return new VmTime(this.nanosElapsed + inc);
    }

    public final VmTime addMs(long durationMs) {
        return this.add(durationMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public final VmTime sub(long duration, TimeUnit unit) {
        return this.add(-duration, unit);
    }

    public final VmTime subMs(long durationMs) {
        return this.sub(durationMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public final VmTime roundTo(TimeUnit unit) {
        return this.roundTo(1L, unit);
    }

    @Override
    public final VmTime roundTo(long duration, TimeUnit unit) {
        long divisor = TimeUnit.NANOSECONDS.convert(duration, unit);
        return new VmTime(this.nanosElapsed / divisor * divisor);
    }

    public final long to(TimeUnit unit) {
        return unit.convert(this.nanosElapsed, TimeUnit.NANOSECONDS);
    }

    public final long toMinutes() {
        return this.to(TimeUnit.MINUTES);
    }

    public final long toSeconds() {
        return this.to(TimeUnit.SECONDS);
    }

    public final long toMilliseconds() {
        return this.to(TimeUnit.MILLISECONDS);
    }

    public long toNanos() {
        return this.nanosElapsed;
    }

    @Override
    public final long diff(VmTime that, TimeUnit unit) {
        long diffNanos = this.nanosElapsed - that.nanosElapsed;
        if (unit == TimeUnit.NANOSECONDS) {
            return diffNanos;
        }
        return unit.convert(diffNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public final int compareTo(VmTime that) {
        return Long.compare(this.nanosElapsed, that.nanosElapsed);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof VmTime)) {
            return false;
        }
        VmTime that = (VmTime)obj;
        return this.nanosElapsed == that.nanosElapsed;
    }

    public final int hashCode() {
        return Long.hashCode(this.nanosElapsed);
    }

    public final String toString() {
        return Long.toString(this.nanosElapsed);
    }

    public final String toPrettyString(TimeUnit unit) {
        return this.toPrettyString(unit, false);
    }

    public final String toPrettyString(TimeUnit unit, boolean hideZeroPart) {
        switch (unit) {
            case DAYS: {
                return this.toPrettyHelper(TimeUnit.DAYS, TimeUnit.HOURS, hideZeroPart);
            }
            case HOURS: {
                return this.toPrettyHelper(TimeUnit.HOURS, TimeUnit.MINUTES, hideZeroPart);
            }
            case MINUTES: {
                return this.toPrettyHelper(TimeUnit.MINUTES, TimeUnit.SECONDS, hideZeroPart);
            }
            case SECONDS: {
                return this.toPrettyHelper(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, hideZeroPart);
            }
        }
        return this.toString(unit);
    }

    private String toPrettyHelper(TimeUnit majorUnit, TimeUnit minorUnit, boolean hideZeroPart) {
        long majorCount = this.to(majorUnit);
        long minorBaseCount = minorUnit.convert(majorCount, majorUnit);
        long minorCount = this.to(minorUnit);
        long minorDelta = minorCount - minorBaseCount;
        StringBuilder builder = new StringBuilder();
        builder.append(majorCount).append(this.unitAffix(majorUnit));
        if (!hideZeroPart || minorDelta != 0L) {
            builder.append(' ');
            builder.append(minorDelta).append(this.unitAffix(minorUnit));
        }
        return builder.toString();
    }

    @Override
    public final String toString(TimeUnit unit) {
        if (unit == TimeUnit.NANOSECONDS) {
            return this.nanosElapsed + this.unitAffix(TimeUnit.NANOSECONDS);
        }
        long divisorNanos = TimeUnit.NANOSECONDS.convert(1L, unit);
        long intPartUnit = this.nanosElapsed / divisorNanos;
        long remainderMs = this.nanosElapsed - intPartUnit * divisorNanos;
        double fractPartUnit = (double)remainderMs / (double)divisorNanos;
        StringBuilder builder = new StringBuilder();
        if (remainderMs == 0L) {
            builder.append(intPartUnit);
        } else {
            builder.append(String.format("%.3f", (double)intPartUnit + fractPartUnit));
        }
        builder.append(this.unitAffix(unit));
        return builder.toString();
    }

    private String unitAffix(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        MIN = ZERO = new VmTime(0L);
        MAX = new VmTime(Long.MAX_VALUE);
    }
}

