/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.AppStoppedTimeAggregation;
import com.azul.log.gctoolkitInterface.dtos.AppStoppedTimeDTO;
import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.jvm.ApplicationStoppedTime;

@Aggregates(value={EventSource.G1GC, EventSource.JVM})
public class AppStoppedTimeAggregator
extends Aggregator<AppStoppedTimeAggregation> {
    public AppStoppedTimeAggregator(AppStoppedTimeAggregation aggregation) {
        super(aggregation);
        this.register(ApplicationStoppedTime.class, this::process);
    }

    private void process(ApplicationStoppedTime event) {
        AppStoppedTimeDTO appStoppedTimeDTO = new AppStoppedTimeDTO();
        appStoppedTimeDTO.setStoppedTime(event.getDuration());
        appStoppedTimeDTO.setStoppingTime(event.getTimeToStopThreads());
        ((AppStoppedTimeAggregation)this.aggregation()).record(appStoppedTimeDTO, event.getDateTimeStamp());
    }
}

