/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.ConcurrentTimesAggregation;
import com.azul.log.gctoolkitInterface.dtos.G1ConcurrentTimesDTO;
import com.azul.log.gctoolkitInterface.dtos.ZGCConcurrentTimesDTO;
import com.azul.log.gctoolkitInterface.general.enums.GenerationType;
import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentCleanupForNextMark;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentClearClaimedMarks;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentScanRootRegion;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentMark;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentRebuildRememberedSets;
import com.microsoft.gctoolkit.event.zgc.FullZGCCycle;
import com.microsoft.gctoolkit.event.zgc.MajorZGCCycle;
import com.microsoft.gctoolkit.event.zgc.MinorZGCCycle;
import com.microsoft.gctoolkit.event.zgc.ZGCCycle;
import com.microsoft.gctoolkit.time.DateTimeStamp;

@Aggregates(value={EventSource.G1GC, EventSource.ZGC})
public class ConcurrentTimesAggregator
extends Aggregator<ConcurrentTimesAggregation> {
    public ConcurrentTimesAggregator(ConcurrentTimesAggregation aggregation) {
        super(aggregation);
        this.register(ConcurrentClearClaimedMarks.class, this::process);
        this.register(ConcurrentScanRootRegion.class, this::process);
        this.register(G1ConcurrentMark.class, this::process);
        this.register(G1ConcurrentRebuildRememberedSets.class, this::process);
        this.register(ConcurrentCleanupForNextMark.class, this::process);
        this.register(FullZGCCycle.class, this::process);
        this.register(MajorZGCCycle.class, this::process);
        this.register(MinorZGCCycle.class, this::process);
    }

    private void process(ConcurrentClearClaimedMarks event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setClearClaimedMarksDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(ConcurrentScanRootRegion event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setScanRootRegionDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(G1ConcurrentMark event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setMarkDuration(event.getDuration());
        concurrentTimesDTO.setMarkFromRootDuration(event.getMarkFromRootsDuration());
        concurrentTimesDTO.setPrecleanDuration(event.getPrecleanDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(G1ConcurrentRebuildRememberedSets event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setRebuildRememberedSetsDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(ConcurrentCleanupForNextMark event) {
        G1ConcurrentTimesDTO concurrentTimesDTO = new G1ConcurrentTimesDTO();
        concurrentTimesDTO.setCleanupForNextMarkDuration(event.getDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void process(FullZGCCycle event) {
        ZGCConcurrentTimesDTO concurrentTimesDTO = new ZGCConcurrentTimesDTO(GenerationType.FULL);
        concurrentTimesDTO.setProcessNonStrongRefs(event.getConcurrentProcessNonStrongReferencesDuration());
        concurrentTimesDTO.setResetRelocationSet(event.getConcurrentResetRelocationSetDuration());
        concurrentTimesDTO.setSelectRelocationSet(event.getConcurrentSelectRelocationSetDuration());
        concurrentTimesDTO.setRelocate(event.getConcurrentRelocateDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, event.getDateTimeStamp());
    }

    private void processZGCCycle(ZGCCycle cycle, GenerationType generation, DateTimeStamp timeStamp) {
        ZGCConcurrentTimesDTO concurrentTimesDTO = new ZGCConcurrentTimesDTO(generation);
        concurrentTimesDTO.setProcessNonStrongRefs(cycle.getConcurrentProcessNonStrongReferencesDuration());
        concurrentTimesDTO.setResetRelocationSet(cycle.getConcurrentResetRelocationSetDuration());
        concurrentTimesDTO.setSelectRelocationSet(cycle.getConcurrentSelectRelocationSetDuration());
        concurrentTimesDTO.setRelocate(cycle.getConcurrentRelocateDuration());
        ((ConcurrentTimesAggregation)this.aggregation()).recordConcurrentTime(concurrentTimesDTO, timeStamp);
    }

    private void process(MajorZGCCycle event) {
        this.processZGCCycle(event.getYoungCycle(), GenerationType.YOUNG, event.getDateTimeStamp());
        this.processZGCCycle(event.getOldCycle(), GenerationType.OLD, event.getDateTimeStamp());
    }

    private void process(MinorZGCCycle event) {
        this.processZGCCycle(event.getYoungCycle(), GenerationType.YOUNG, event.getDateTimeStamp());
    }
}

