/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.EvacuationPhaseAggregation;
import com.azul.log.gctoolkitInterface.dtos.EvacuationTimesDTO;
import com.azul.log.gctoolkitInterface.general.enums.EvacuationPhase;
import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.g1gc.G1Young;

@Aggregates(value={EventSource.G1GC})
public class EvacuationPhaseAggregator
extends Aggregator<EvacuationPhaseAggregation> {
    public EvacuationPhaseAggregator(EvacuationPhaseAggregation aggregation) {
        super(aggregation);
        this.register(G1Young.class, this::extractEvacuationTime);
    }

    private void extractEvacuationTime(G1Young event) {
        EvacuationTimesDTO evacuationTimesDTO = new EvacuationTimesDTO();
        event.phaseNames().forEachRemaining(phaseName -> {
            EvacuationPhase phase = EvacuationPhase.fromString(phaseName);
            double phaseDuration = event.phaseDurationFor((String)phaseName);
            switch (phase) {
                case PRE_EVACUATE_COLLECTION: {
                    evacuationTimesDTO.setPreEvDuration(phaseDuration);
                    break;
                }
                case EVACUATE_COLLECTION: {
                    evacuationTimesDTO.setEvDuration(phaseDuration);
                    break;
                }
                case POST_EVACUATE_COLLECTION: {
                    evacuationTimesDTO.setPostEvDuration(phaseDuration);
                    break;
                }
                case OTHER: {
                    evacuationTimesDTO.setOtherDuration(phaseDuration);
                }
            }
        });
        ((EvacuationPhaseAggregation)this.aggregation()).recordEvacuationTime(event.getGarbageCollectionType(), evacuationTimesDTO, event.getDateTimeStamp());
    }
}

