/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.G1PhaseTimesAggregation;
import com.azul.log.gctoolkitInterface.dtos.G1PhaseTimesDTO;
import com.azul.log.gctoolkitInterface.general.enums.EvacuationPhase;
import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.g1gc.G1Young;

@Aggregates(value={EventSource.G1GC})
public class G1PhaseTimesAggregator
extends Aggregator<G1PhaseTimesAggregation> {
    public G1PhaseTimesAggregator(G1PhaseTimesAggregation aggregation) {
        super(aggregation);
        this.register(G1Young.class, this::process);
    }

    private void process(G1Young event) {
        G1PhaseTimesDTO pauseDataDTO = new G1PhaseTimesDTO(event.getCodeRootFixupDuration(), event.getCodeRootPurgeDuration(), event.getClearCTDuration(), event.getOtherPhaseDurations(), event.getParallelPhaseDurationTime(), event.getWorkersStart() != null ? event.getWorkersStart().getDiff() : 0.0, event.parallelPhaseSummaryFor("Ext Root Scanning") != null ? event.parallelPhaseSummaryFor("Ext Root Scanning").getDiff() : 0.0, event.parallelPhaseSummaryFor("Update RS") != null ? event.parallelPhaseSummaryFor("Update RS").getDiff() : 0.0, event.parallelPhaseSummaryFor("Scan RS") != null ? event.parallelPhaseSummaryFor("Scan RS").getDiff() : 0.0, event.parallelPhaseSummaryFor("Code Root Scanning") != null ? event.parallelPhaseSummaryFor("Code Root Scanning").getDiff() : 0.0, event.parallelPhaseSummaryFor("Object Copy") != null ? event.parallelPhaseSummaryFor("Object Copy").getDiff() : 0.0, event.parallelPhaseSummaryFor("Termination") != null ? event.parallelPhaseSummaryFor("Termination").getDiff() : 0.0, event.getWorkerOther() != null ? event.getWorkerOther().getDiff() : 0.0, event.getWorkerTotal() != null ? event.getWorkerTotal().getDiff() : 0.0, event.getWorkersEnd() != null ? event.getWorkersEnd().getDiff() : 0.0);
        event.phaseNames().forEachRemaining(phaseName -> {
            if (phaseName.equals(EvacuationPhase.CHOOSE_CSET.get())) {
                pauseDataDTO.setChooseCSetDuration(event.phaseDurationFor(EvacuationPhase.CHOOSE_CSET.get()));
            } else if (phaseName.equals(EvacuationPhase.REF_PROC.get())) {
                pauseDataDTO.setRefProcDuration(event.phaseDurationFor(EvacuationPhase.REF_PROC.get()));
            } else if (phaseName.equals(EvacuationPhase.REF_ENQ.get())) {
                pauseDataDTO.setRefEnqDuration(event.phaseDurationFor(EvacuationPhase.REF_ENQ.get()));
            } else if (phaseName.equals(EvacuationPhase.REDIRTY_CARDS.get())) {
                pauseDataDTO.setRedirtyCardsDuration(event.phaseDurationFor(EvacuationPhase.REDIRTY_CARDS.get()));
            } else if (phaseName.equals(EvacuationPhase.HUMONGOUS_REGISTER.get())) {
                pauseDataDTO.setHumongousRegisterDuration(event.phaseDurationFor(EvacuationPhase.HUMONGOUS_REGISTER.get()));
            } else if (phaseName.equals(EvacuationPhase.HUMONGOUS_RECLAIM.get())) {
                pauseDataDTO.setHumongousReclaimDuration(event.phaseDurationFor(EvacuationPhase.HUMONGOUS_RECLAIM.get()));
            } else if (phaseName.equals(EvacuationPhase.FREE_CSET.get())) {
                pauseDataDTO.setFreeCSetDuration(event.phaseDurationFor(EvacuationPhase.FREE_CSET.get()));
            }
        });
        ((G1PhaseTimesAggregation)this.aggregation()).recordPhaseTimes(event.getGarbageCollectionType(), pauseDataDTO, event.getDateTimeStamp());
    }
}

