/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.WorkersAggregation;
import com.azul.log.gctoolkitInterface.dtos.WorkersDTO;
import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.g1gc.G1Young;

@Aggregates(value={EventSource.G1GC})
public class WorkersAggregator
extends Aggregator<WorkersAggregation> {
    public WorkersAggregator(WorkersAggregation aggregation) {
        super(aggregation);
        this.register(G1Young.class, this::process);
    }

    private void process(G1Young event) {
        WorkersDTO workersDTO = new WorkersDTO();
        workersDTO.setEvacuationWorkersUsed(event.getEvacuationWorkersUsed());
        workersDTO.setEvacuationWorkersAvailable(event.getEvacuationWorkersAvailable());
        workersDTO.setGcWorkers(event.getGcWorkers());
        workersDTO.setStringDeduppingWorkers(event.getStringDeduppingWorkers());
        ((WorkersAggregation)this.aggregation()).recordWorker(event.getGarbageCollectionType(), workersDTO, event.getDateTimeStamp());
    }
}

