/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.general;

import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TimestampedDataSet<T> {
    protected final List<Point<T>> dataSeries;

    public TimestampedDataSet() {
        this.dataSeries = new ArrayList<Point<T>>();
    }

    public TimestampedDataSet(TimestampedDataSet<T> series) {
        this.dataSeries = new ArrayList<Point<T>>(series.getItems());
    }

    public void add(DateTimeStamp timestamp, T value) {
        this.dataSeries.add(new Point<T>(timestamp, value));
    }

    public void addIfAbsent(DateTimeStamp timestamp, T value) {
        Point<T> point = new Point<T>(timestamp, value);
        if (!this.dataSeries.contains(point)) {
            this.dataSeries.add(point);
        }
    }

    public void add(Point<T> item) {
        this.dataSeries.add(item);
    }

    protected void addAll(List<Point<T>> items) {
        this.dataSeries.addAll(items);
    }

    public boolean isEmpty() {
        return this.dataSeries.isEmpty();
    }

    public List<Point<T>> getItems() {
        return this.dataSeries;
    }

    public int size() {
        return this.dataSeries.size();
    }

    public static class Point<T> {
        private final DateTimeStamp dateTimeStamp;
        private final T value;

        public Point(DateTimeStamp dateTimeStamp, T value) {
            this.dateTimeStamp = dateTimeStamp;
            this.value = value;
        }

        public long getAbsoluteTimestamp() {
            return (long)this.dateTimeStamp.toEpochInMillis();
        }

        public double getRelativeTimestamp() {
            return this.dateTimeStamp.getTimeStamp();
        }

        public T getValue() {
            return this.value;
        }

        public String toString() {
            return this.dateTimeStamp + "," + this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Point otherPoint = (Point)obj;
            return Objects.equals(this.dateTimeStamp, otherPoint.dateTimeStamp);
        }
    }
}

