/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.actions;

import com.azul.log.gui.actions.UIAction;
import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.model.RecentOpenFilesModel;
import com.azul.log.gui.support.DownloadSupport;
import com.azul.log.gui.support.OpenFileSupport;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.utils.CommonUtils;
import java.awt.FileDialog;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class OpenFileAction
extends UIAction {
    private final List<URI> uris;
    private final OpenFileSupport.LogFilesOpenHandler consumer;

    public OpenFileAction(List<URI> uris, OpenFileSupport.LogFilesOpenHandler consumer) {
        this.uris = uris;
        this.consumer = consumer;
    }

    public static JMenuItem getMenuPresenter(TYPE type, OpenFileSupport.LogFilesOpenHandler openLogHandler) {
        JMenuItem openFileMenuItem = new JMenuItem(type.text);
        openFileMenuItem.setToolTipText(type.tooltip);
        openFileMenuItem.addActionListener(new OpenFileAction(null, openLogHandler));
        openFileMenuItem.setAccelerator(type.keyStroke);
        return openFileMenuItem;
    }

    @Override
    protected void performActionImpl() throws IOException {
        if (this.uris == null || this.uris.isEmpty()) {
            FileDialog dialog = new FileDialog(MainFrame.get());
            dialog.setDirectory(Config.getLastSelectedDir());
            dialog.setMode(0);
            dialog.setMultipleMode(true);
            dialog.setVisible(true);
            File[] selection = dialog.getFiles();
            dialog.dispose();
            if (selection.length == 0) {
                return;
            }
            List<File> files = Arrays.asList(selection);
            this.openFiles(files, files.get(0).getParent());
        } else {
            ArrayList<File> files = new ArrayList<File>();
            ArrayList<URI> toDownload = new ArrayList<URI>();
            String dir = null;
            for (URI uri : this.uris) {
                String scheme = uri.getScheme();
                if (scheme == null || "file".equals(scheme)) {
                    File file2 = new File(uri.getPath());
                    if (files.isEmpty()) {
                        dir = file2.getParent();
                    }
                    files.add(file2);
                    continue;
                }
                toDownload.add(uri);
            }
            if (toDownload.isEmpty()) {
                this.openFiles(files, dir);
            } else {
                AtomicInteger left = new AtomicInteger(toDownload.size());
                String directory = dir;
                for (URI uri : toDownload) {
                    DownloadSupport.download(uri, file -> {
                        List list = files;
                        synchronized (list) {
                            files.add((File)file);
                            if (left.decrementAndGet() == 0) {
                                this.openFiles(files, directory);
                            }
                        }
                    });
                }
            }
        }
    }

    private void openFiles(List<File> files, String dir) {
        OpenFileSupport.open(files, (logFiles, error) -> {
            if (error == null && dir != null && !logFiles.isEmpty()) {
                Path tempDir = CommonUtils.getTempDir();
                files.stream().map(File::getAbsoluteFile).map(File::toPath).filter(p -> !p.startsWith(tempDir)).forEach(p -> RecentOpenFilesModel.getModel().addFile(p.toString()));
                Config.setLastSelectedDir(dir);
            }
            this.consumer.accept(logFiles, error);
        });
    }

    public static enum TYPE {
        OPEN("Open File...", "Open Log File", KeyStroke.getKeyStroke(79, UIUtils.MENU_SHORTCUT_KEY_MASK)),
        ADD("Add File...", "Add Log File", KeyStroke.getKeyStroke(79, UIUtils.MENU_SHORTCUT_KEY_MASK | 0x40));

        private final String text;
        private final String tooltip;
        private final KeyStroke keyStroke;

        private TYPE(String text, String tooltip, KeyStroke keyStroke) {
            this.text = text;
            this.tooltip = tooltip;
            this.keyStroke = keyStroke;
        }
    }
}

