/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.markup.api;

import com.azul.log.gui.markup.spi.MarkupProvider;
import com.azul.log.model.api.LogRecord;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openide.util.Lookup;

public final class HTMLMarkup {
    private static final String prefix = "<html><body style=\"font-family:monospace;font-variant: small-caps;\"><pre>";
    private static final String suffix = "</pre></body></html>";
    private static final ThreadLocal<StringBuilder> buffer = ThreadLocal.withInitial(() -> new StringBuilder(prefix));
    private static final int contentMinSize = "<html><body style=\"font-family:monospace;font-variant: small-caps;\"><pre>".length();
    private final Collection<? extends MarkupProvider> providers = Lookup.getDefault().lookupAll(MarkupProvider.class);

    public static String decorate(String text) {
        StringBuilder sb = buffer.get();
        sb.setLength(contentMinSize);
        sb.append(text);
        sb.append(suffix);
        return sb.toString();
    }

    public static String addHTMLColor(String color, String txt, boolean addColor) {
        return addColor ? "<font color='" + color + "'>" + txt + "</font>" : txt;
    }

    private static String escapeCharacters(String text, Map<String, String> mapping) {
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            text = text.replaceAll(entry.getKey(), entry.getValue());
        }
        return text;
    }

    private List<MarkupProvider.Markup> getMarkups(LogRecord record, String line) {
        return this.providers.stream().map(impl -> impl.getMarkups(record, line)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public FormattedHTML highlight(Object record, String text, boolean isSelected) {
        String escapedText = text;
        if (!text.matches("(.*)(<font|<span|<i>|<b>|<a href|<em>|->|<sup>|<small>|<br>|<hr>|<strike>|<p>)(.*)")) {
            escapedText = HTMLMarkup.escapeCharacters(text, Map.of("<", "&lt;", ">", "&gt;"));
        }
        if (record instanceof LogRecord) {
            return this.highlight((LogRecord)record, escapedText, isSelected);
        }
        if (record == null || record instanceof String) {
            return this.highlight(null, escapedText, isSelected);
        }
        return new FormattedHTML(null, escapedText);
    }

    private FormattedHTML highlight(LogRecord record, String text, boolean isSelected) {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        List<MarkupProvider.Markup> markups = this.getMarkups(record, text);
        Color highlight = null;
        for (MarkupProvider.Markup mkp : markups) {
            String style = mkp.getStyle();
            if (style != null) {
                int start = mkp.getStart();
                int end = mkp.getEnd();
                sb.append(text, idx, start);
                sb.append("<span style=\"").append(mkp.getStyle()).append("\">");
                idx = start;
                sb.append(text, idx, end);
                sb.append("</span>");
                idx = end;
                continue;
            }
            Color bg = mkp.getHighlightColor();
            if (bg == null) continue;
            highlight = bg;
        }
        sb.append(text.substring(idx));
        return new FormattedHTML(highlight, sb.toString());
    }

    public static class FormattedHTML {
        public final String html;
        public final Color highlight;

        private FormattedHTML(Color highlight, String html) {
            this.html = html;
            this.highlight = highlight;
        }
    }
}

