/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.markup.impl;

import com.azul.log.gui.markup.spi.MarkupProvider;
import com.azul.log.model.api.LogRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TextHighlightProvider
implements MarkupProvider {
    private static final String HIGHLIGHT_STYLE = "font-weight:bold;color:black;background-color:#F8AF40;";
    private static boolean caseSensitive;
    private static List<String[]> searchContextList;

    public static void setContext(List<String[]> searchContextList, boolean caseSensitive) {
        TextHighlightProvider.caseSensitive = caseSensitive;
        TextHighlightProvider.searchContextList = searchContextList;
    }

    public static void reset() {
        searchContextList = Collections.emptyList();
    }

    @Override
    public List<? extends MarkupProvider.Markup> getMarkups(LogRecord record, String line) {
        if (searchContextList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MarkupProvider.StyleMarkup> res = new ArrayList<MarkupProvider.StyleMarkup>();
        if (!caseSensitive) {
            line = line.toLowerCase();
        }
        for (String[] searchOpAndInputString : searchContextList) {
            String selectedOperation = searchOpAndInputString[0];
            String searchText = caseSensitive ? searchOpAndInputString[1] : searchOpAndInputString[1].toLowerCase();
            if (searchText.isEmpty()) continue;
            if (selectedOperation.equals("Contains") && line.contains(searchText)) {
                int idx = 0;
                while ((idx = line.indexOf(searchText, idx)) >= 0) {
                    res.add(new MarkupProvider.StyleMarkup(idx, idx + searchText.length(), HIGHLIGHT_STYLE));
                    idx += searchText.length();
                }
                continue;
            }
            if (selectedOperation.equals("Not Contains") && line.contains(searchText)) {
                return Collections.emptyList();
            }
            if (selectedOperation.equals("Not Contains") && !line.contains(searchText)) continue;
            if (selectedOperation.equals("Begins with") && line.startsWith(searchText)) {
                res.add(new MarkupProvider.StyleMarkup(0, searchText.length(), HIGHLIGHT_STYLE));
                continue;
            }
            if (selectedOperation.equals("Ends with") && line.endsWith(searchText)) {
                res.add(new MarkupProvider.StyleMarkup(line.length() - searchText.length(), line.length(), HIGHLIGHT_STYLE));
                continue;
            }
            if (selectedOperation.equals("Equals") && line.equals(searchText)) {
                res.add(new MarkupProvider.StyleMarkup(0, searchText.length(), HIGHLIGHT_STYLE));
                continue;
            }
            if (selectedOperation.equals("Not Equals") && !line.equals(searchText)) {
                res.add(new MarkupProvider.StyleMarkup(0, line.length(), HIGHLIGHT_STYLE));
                continue;
            }
            return Collections.emptyList();
        }
        return this.adjustForCollision(res);
    }

    private List<? extends MarkupProvider.Markup> adjustForCollision(List<MarkupProvider.StyleMarkup> res) {
        if (res.size() <= 1) {
            return res;
        }
        Collections.sort(res, Comparator.comparingInt(MarkupProvider.StyleMarkup::getStart));
        for (int i = 0; i < res.size() - 1; ++i) {
            MarkupProvider.StyleMarkup style1 = res.get(i);
            MarkupProvider.StyleMarkup style2 = res.get(i + 1);
            if (style2.getStart() > style1.getEnd()) continue;
            res.remove(i);
            res.remove(i);
            res.add(i, new MarkupProvider.StyleMarkup(style1.getStart(), Math.max(style1.getEnd(), style2.getEnd()), HIGHLIGHT_STYLE));
            --i;
        }
        return res;
    }

    static {
        searchContextList = Collections.emptyList();
    }
}

