/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.gui.model.PersistentModel;
import com.azul.log.gui.model.support.AbstractModel;
import com.azul.log.utils.CommonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class RecentOpenFilesModel
extends AbstractModel
implements PersistentModel {
    private static final RecentOpenFilesModel model = new RecentOpenFilesModel();
    private final List<String> files = new ArrayList<String>();

    private RecentOpenFilesModel() {
    }

    public static RecentOpenFilesModel getModel() {
        return model;
    }

    public synchronized List<String> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public synchronized void addFile(String path) {
        this.files.remove(path);
        this.files.add(0, path);
        if (this.files.size() > 15) {
            this.files.remove(15);
        }
        this.fireChange();
    }

    public synchronized void removeFile(String path) {
        this.files.remove(path);
        this.fireChange();
    }

    public void setFiles(List<String> list) {
        this.files.clear();
        list.stream().filter(CommonUtils.not(String::isEmpty)).forEachOrdered(this.files::add);
        this.fireChange();
    }

    @Override
    public String getPersistentID() {
        return "RecentFiles";
    }

    @Override
    public String toExternalString() {
        return String.join((CharSequence)File.pathSeparator, this.getFiles());
    }

    @Override
    public void initFromExternalString(String str) {
        this.files.clear();
        if (str != null) {
            Arrays.stream(str.split(File.pathSeparator)).filter(CommonUtils.not(String::isEmpty)).forEach(this.files::add);
        }
        this.fireChange();
    }
}

