/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.model.GraphsSelectorModel;
import com.azul.log.gui.model.support.AbstractModel;
import com.azul.log.gui.ui.ScratchpadPanel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;

public class ScratchpadModel
extends AbstractModel {
    private static final ScratchpadModel model = new ScratchpadModel();
    private final Map<GraphDefinition, Integer> displayedGraphs = new HashMap<GraphDefinition, Integer>();
    private final List<Integer> freeIndexes = new LinkedList<Integer>();

    private ScratchpadModel() {
    }

    public static ScratchpadModel getModel() {
        return model;
    }

    public boolean isDisplayed(GraphDefinition gd) {
        return this.displayedGraphs.containsKey(gd);
    }

    public int add(GraphDefinition gd) {
        int datasetInsertIndex = this.getDatasetInsertIndex();
        this.displayedGraphs.put(gd, datasetInsertIndex);
        this.fireChange();
        return datasetInsertIndex;
    }

    public int remove(GraphDefinition gd) {
        int freeIndex = this.displayedGraphs.remove(gd);
        if (this.isEmpty()) {
            this.freeIndexes.clear();
        } else {
            this.freeIndexes.add(freeIndex);
        }
        this.fireChange();
        return freeIndex;
    }

    public Map<GraphDefinition, Integer> getDisplayedGraphs() {
        return Collections.unmodifiableMap(this.displayedGraphs);
    }

    public int getDatasetIndex(GraphDefinition gd) {
        return this.displayedGraphs.get(gd);
    }

    public GraphDefinition getGraphDefinitionForDataset(XYPlot plot, XYDataset dataset) {
        Optional<GraphDefinition> gd = this.displayedGraphs.entrySet().stream().filter(entry -> plot.getDataset((Integer)entry.getValue()).equals(dataset)).map(Map.Entry::getKey).findFirst();
        return gd.orElse(null);
    }

    public void reset(ScratchpadPanel scratchpadPanel) {
        this.clear(scratchpadPanel.getMainPlot(), scratchpadPanel.getSliderPlot());
        scratchpadPanel.resetZoom();
        GraphsSelectorModel graphsSelectorModel = GraphsSelectorModel.getModel();
        if (graphsSelectorModel.getActiveMode() == GraphsSelectorModel.Mode.SCRATCHPAD) {
            GraphsSelectorModel.getModel().setActiveMode(GraphsSelectorModel.Mode.ALL);
        }
    }

    public void clear(XYPlot mainPlot, XYPlot sliderPlot) {
        Iterator<GraphDefinition> iterator = this.displayedGraphs.keySet().iterator();
        while (iterator.hasNext()) {
            GraphDefinition gd = iterator.next();
            int freedIndex = this.displayedGraphs.get(gd);
            mainPlot.setDataset(freedIndex, null);
            mainPlot.setRenderer(freedIndex, null);
            sliderPlot.setDataset(freedIndex, null);
            sliderPlot.setRenderer(freedIndex, null);
            iterator.remove();
        }
        this.freeIndexes.clear();
        this.fireChange();
    }

    public boolean isEmpty() {
        return this.displayedGraphs.isEmpty();
    }

    private int getDatasetInsertIndex() {
        if (this.displayedGraphs.isEmpty()) {
            this.freeIndexes.clear();
            return 0;
        }
        if (this.freeIndexes.isEmpty()) {
            return this.displayedGraphs.size();
        }
        return this.freeIndexes.remove(0);
    }
}

