/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.search;

import com.azul.log.gui.ui.NMT_SearchPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class NMT_TableFilterer<M extends TableModel>
extends TableRowSorter<M> {
    private static final String FILTER_MALLOC = "Malloc";
    private static final String FILTER_MMAP = "Mmap";
    private final String mode;
    private final List<Integer> viewToModel;
    private final List<Integer> modelToView;
    private final NMT_SearchPanel searchPanel;
    private final Runnable refreshTableAction;
    private final AtomicBoolean interrupt;

    public NMT_TableFilterer(M model, NMT_SearchPanel searchPanel, Runnable refreshTableAction, String mode) {
        super(model);
        this.searchPanel = searchPanel;
        this.refreshTableAction = refreshTableAction;
        this.mode = mode;
        this.viewToModel = Collections.synchronizedList(new ArrayList());
        this.modelToView = Collections.synchronizedList(new ArrayList());
        this.interrupt = new AtomicBoolean(false);
    }

    public void filter() {
        this.interrupt.set(false);
        int rowCount = this.getModelWrapper().getRowCount();
        Timer timer = new Timer(true);
        this.viewToModel.clear();
        this.modelToView.clear();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(NMT_TableFilterer.this.refreshTableAction);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS.toMillis(1L));
        int viewCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            this.searchPanel.setProgress(i);
            if (this.interrupt.get()) {
                timer.cancel();
                return;
            }
            if (this.include(i)) {
                this.viewToModel.add(i);
                this.modelToView.add(viewCount++);
                continue;
            }
            this.modelToView.add(-1);
        }
        timer.cancel();
    }

    private boolean isFilteringEnabled() {
        return this.searchPanel.applyFiltering();
    }

    @Override
    public int getViewRowCount() {
        if (this.isFilteringEnabled()) {
            return this.viewToModel.size();
        }
        return this.getModelWrapper().getRowCount();
    }

    @Override
    public int convertRowIndexToView(int index) {
        return this.modelToView.get(index);
    }

    @Override
    public int convertRowIndexToModel(int index) {
        if (this.isFilteringEnabled()) {
            try {
                return this.viewToModel.get(index);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return index;
    }

    private boolean include(int row) {
        return this.isTextPresentInRow(row);
    }

    private boolean isTextPresentInRow(int row) {
        Map<String, Function<String, Boolean>> filters = this.searchPanel.getSearchFilters();
        boolean satisfyComponents = filters.keySet().stream().noneMatch(key -> key.startsWith("JVM Component"));
        boolean satisfySize = filters.keySet().stream().noneMatch(key -> key.startsWith("Size"));
        for (String filterType : filters.keySet()) {
            int column;
            Function<String, Boolean> filter = filters.get(filterType);
            if (filterType.startsWith("JVM Component")) {
                column = 2;
            } else if (filterType.startsWith("Size")) {
                column = 1;
            } else {
                return false;
            }
            if (this.mode.equals(FILTER_MMAP)) {
                ++column;
            }
            String rawLine = (String)((TableModel)this.getModel()).getValueAt(row, column);
            if (!this.searchPanel.isCaseSensitive()) {
                rawLine = rawLine.toUpperCase();
            }
            if (filter.apply(rawLine).booleanValue() && filterType.startsWith("JVM Component")) {
                satisfyComponents = true;
            }
            if (!filter.apply(rawLine).booleanValue() || !filterType.startsWith("Size")) continue;
            satisfySize = true;
        }
        return satisfyComponents && satisfySize;
    }

    public void reset() {
        this.interrupt.set(true);
        this.refreshTableAction.run();
    }

    @Override
    public void sort() {
    }

    @Override
    public boolean isSortable(int column) {
        return false;
    }

    @Override
    public void setRowFilter(RowFilter<? super M, ? super Integer> filter) {
        this.raiseUnsupportedOperationException();
    }

    @Override
    public void toggleSortOrder(int column) {
        this.raiseUnsupportedOperationException();
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
        super.setSortKeys(null);
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return Collections.emptyList();
    }

    private void raiseUnsupportedOperationException() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support this operation");
    }
}

