/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.advisor.api.Advice;
import com.azul.log.advisor.api.Advices;
import com.azul.log.gui.actions.ViewLogAction;
import com.azul.log.gui.graphs.api.PlotData;
import com.azul.log.gui.markup.api.HTMLMarkup;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.ui.ContentPanel;
import com.azul.log.gui.ui.GraphPanel;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.ui.RangeSlider;
import com.azul.log.gui.ui.ScrollBarUIEx;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.model.api.LogModel;
import com.azul.log.utils.TextToHTML;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.openide.util.Lookup;

public final class AdvisoryPanel
extends ContentPanel
implements ChangeListener {
    private final JTable table;
    private final Map<Integer, String> links = new HashMap<Integer, String>();
    private final Map<Integer, String> lookupElements = new HashMap<Integer, String>();
    private final List<Integer> groupHeaders = new ArrayList<Integer>();
    private final JLabel groupHeader;
    private final TimeRangeSelectionModel.VisibleTimeRangeModel visibleTimeRangeModel = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);

    public static AdvisoryPanel create() {
        return new AdvisoryPanel();
    }

    private AdvisoryPanel() {
        super(Lookup.EMPTY);
        this.setLayout(new BorderLayout());
        this.groupHeader = new JLabel();
        this.groupHeader.setBorder(new EmptyBorder(0, 5, 0, 0));
        DefaultTableModel model = new DefaultTableModel(0, 2);
        this.table = new JTable(model){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                Container viewPort = this.getParent();
                if (viewPort instanceof JViewport) {
                    return this.getPreferredSize().width < viewPort.getWidth();
                }
                return false;
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(Color.DARK_GRAY);
                Rectangle clip = g.getClipBounds();
                if (clip == null) {
                    return;
                }
                for (Integer row : AdvisoryPanel.this.groupHeaders) {
                    if (row >= this.getRowCount()) continue;
                    Rectangle rect = this.getCellRect(row, 0, true);
                    int y = rect.y + rect.height - 1;
                    if (y < clip.y || y >= clip.y + clip.height) continue;
                    g.drawLine(clip.x, y, clip.x + clip.width - 1, y);
                }
            }
        };
        this.table.setDefaultRenderer(Object.class, new CellRenderer());
        this.table.setDefaultEditor(Object.class, null);
        this.table.setTableHeader(null);
        this.table.setBackground(Color.WHITE);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = AdvisoryPanel.this.table.columnAtPoint(e.getPoint());
                if (col == 1) {
                    int rowNumber = AdvisoryPanel.this.table.rowAtPoint(e.getPoint());
                    String uri = AdvisoryPanel.this.links.get(AdvisoryPanel.this.table.rowAtPoint(e.getPoint()));
                    if (uri != null) {
                        Desktop desktop = Desktop.getDesktop();
                        try {
                            desktop.browse(new URI(uri));
                        }
                        catch (IOException | URISyntaxException ex) {
                            UIUtils.copyTextToClipboard(uri);
                        }
                    }
                    if (AdvisoryPanel.this.lookupElements.get(rowNumber) != null && !AdvisoryPanel.this.lookupElements.get(rowNumber).trim().isEmpty()) {
                        String firstLookupElement = AdvisoryPanel.this.lookupElements.get(rowNumber);
                        try {
                            int logLineNumber = Integer.parseInt(firstLookupElement);
                            if (logLineNumber != -1) {
                                UIElementSelectionModel selectionModel = UIElementSelectionModel.getInstance();
                                selectionModel.setSelectedElement(new UIElement(null, logLineNumber, Context.lookup(LogModel.class)));
                                new ViewLogAction().actionPerformed((ActionEvent)null);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            Context.lookup(PlotData.class).getGraphDefinitions().stream().filter(x -> x.getTitle().equals(firstLookupElement)).findFirst().ifPresent(graphDefinition -> MainFrame.get().setContentPanel(GraphPanel.create(graphDefinition)));
                        }
                    }
                }
            }
        });
        this.table.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int col = AdvisoryPanel.this.table.columnAtPoint(e.getPoint());
                if (col == 1) {
                    int row = AdvisoryPanel.this.table.rowAtPoint(e.getPoint());
                    AdvisoryPanel.this.table.setCursor(AdvisoryPanel.this.links.get(row) != null || AdvisoryPanel.this.lookupElements.get(row) != null ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
                }
            }
        });
        UIUtils.fixCopyPasteActionHotKeys(this.table);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
        ScrollBarUIEx.setup(scrollPane, false);
        this.add((Component)scrollPane, "Center");
        RangeSlider rangeSlider = new RangeSlider((BoundedRangeModel)((Object)this.visibleTimeRangeModel));
        JPanel compositePanel = new JPanel();
        compositePanel.setLayout(new BorderLayout());
        compositePanel.add((Component)scrollPane, "Center");
        compositePanel.add((Component)rangeSlider, "South");
        this.add((Component)compositePanel, "Center");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Font font = this.table.getFont();
        this.groupHeader.setFont(font.deriveFont(1));
        FontMetrics metrics = this.table.getFontMetrics(font);
        this.table.setRowHeight(metrics.getHeight());
        this.visibleTimeRangeModel.addChangeListener(this);
        this.stateChanged(null);
    }

    @Override
    public void removeNotify() {
        this.visibleTimeRangeModel.removeChangeListener(this);
        super.removeNotify();
    }

    private void setColumnWidths() {
        Component comp;
        TableCellRenderer renderer;
        int row;
        TableColumnModel columnModel = this.table.getColumnModel();
        int width = 300;
        for (row = 0; row < this.table.getRowCount(); ++row) {
            renderer = this.table.getCellRenderer(row, 0);
            comp = this.table.prepareRenderer(renderer, row, 0);
            width = Math.max(comp.getPreferredSize().width + 1, width);
        }
        columnModel.getColumn(0).setPreferredWidth(width += 20);
        columnModel.getColumn(0).setMaxWidth(width);
        width = 0;
        for (row = 0; row < this.table.getRowCount(); ++row) {
            renderer = this.table.getCellRenderer(row, 1);
            comp = this.table.prepareRenderer(renderer, row, 1);
            width = Math.max(comp.getPreferredSize().width + 1, width);
        }
        columnModel.getColumn(1).setPreferredWidth(width);
        columnModel.getColumn(1).setMaxWidth(width);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateTableModel();
    }

    private void updateTableModel() {
        this.groupHeaders.clear();
        this.links.clear();
        this.lookupElements.clear();
        DefaultTableModel model = new DefaultTableModel(0, 2);
        this.addAdvices(model);
        this.table.setModel(model);
        this.setColumnWidths();
    }

    private void addAdvices(DefaultTableModel model) {
        Advices advices = Context.lookup(Advices.class);
        if (advices == null || advices.isEmpty()) {
            return;
        }
        List advicesList = advices.stream().map(advice -> (Optional)advice.apply(this.visibleTimeRangeModel.getSelection().getStart().getInUnits(TimeUnit.SECONDS), this.visibleTimeRangeModel.getSelection().getEnd().getInUnits(TimeUnit.SECONDS))).filter(Optional::isPresent).map(Optional::get).sorted(Advice::compareTo).collect(Collectors.toList());
        model.addRow(new String[]{"", ""});
        model.addRow(new String[]{"Auto Analysis", ""});
        this.groupHeaders.add(model.getRowCount() - 1);
        String groupHeader = "";
        String prevGroupHeader = "";
        for (Advice advice2 : advicesList) {
            String currGroupHeader = advice2.severity.getCategory();
            if (!prevGroupHeader.equals(currGroupHeader)) {
                this.groupHeaders.add(model.getRowCount() - 1);
                groupHeader = currGroupHeader;
                prevGroupHeader = currGroupHeader;
            } else {
                groupHeader = "";
            }
            model.addRow(new String[]{TextToHTML.toBold(groupHeader), TextToHTML.toBoldItalic(advice2.advice)});
            if (advice2.recipe != null) {
                Arrays.stream(advice2.recipe.split("\n")).forEach(recipeLine -> model.addRow(new String[]{"", recipeLine}));
            }
            advice2.url.ifPresent(url -> {
                this.links.put(model.getRowCount(), (String)url);
                model.addRow(new String[]{"", "For more information follow this link: " + TextToHTML.toHyperlink(url)});
            });
            advice2.lookupElement.ifPresent(lookupElement -> {
                this.lookupElements.put(model.getRowCount(), (String)lookupElement);
                model.addRow(new String[]{"", TextToHTML.toHyperlink("", "Go to source")});
            });
            model.addRow(new String[]{"", ""});
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private final HTMLMarkup htmlMarkup = new HTMLMarkup();

        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (AdvisoryPanel.this.groupHeaders.contains(row)) {
                AdvisoryPanel.this.groupHeader.setText(column == 0 ? (String)value : "");
                return AdvisoryPanel.this.groupHeader;
            }
            String html = this.htmlMarkup.highlight((Object)value, (String)String.valueOf((Object)value), (boolean)isSelected).html;
            return super.getTableCellRendererComponent(table, HTMLMarkup.decorate(html), isSelected, hasFocus, row, column);
        }
    }
}

