/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.utils.UIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthToolTipUI;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;

public final class CustomTooltipSupport {
    private static final int DELAY = Config.getIntProperty("CustomTooltipSupport.delay", 200);
    private static CustomTooltipSupport instance;
    private final JPanel glassPanel;
    private final TooltipContent content = new TooltipContent();
    private final TooltipListener listener = new TooltipListener();
    private final JToolTip tooltip;
    private String text;

    private CustomTooltipSupport() {
        this.glassPanel = (JPanel)MainFrame.get().getGlassPane();
        this.glassPanel.setLayout(null);
        this.glassPanel.setVisible(true);
        UIUtils.fixCopyPasteActionHotKeys(this.content);
        this.content.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomTooltipSupport.this.listener.hideCustom();
            }
        }, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.tooltip = new JToolTip(){
            {
                this.setUI(new SynthToolTipUI(){

                    @Override
                    protected void paint(SynthContext context, Graphics g) {
                        Point location = this.getLocationOnScreen();
                        SwingUtilities.convertPointFromScreen(location, CustomTooltipSupport.this.glassPanel);
                        CustomTooltipSupport.this.content.setLocation(location);
                        CustomTooltipSupport.this.content.setSize(this.getSize());
                        CustomTooltipSupport.this.content.paint(g);
                    }
                });
            }

            @Override
            public void setTipText(String tipText) {
                super.setTipText(tipText);
                CustomTooltipSupport.this.text = tipText;
            }
        };
        this.tooltip.addAncestorListener(this.listener);
    }

    private static CustomTooltipSupport getInstance() {
        assert (SwingUtilities.isEventDispatchThread());
        if (instance == null) {
            instance = new CustomTooltipSupport();
        }
        return instance;
    }

    public static JToolTip createTooltip(JComponent owner) {
        return CustomTooltipSupport.getInstance().createTooltipImpl(owner);
    }

    private JToolTip createTooltipImpl(JComponent owner) {
        this.tooltip.setComponent(owner);
        return this.tooltip;
    }

    private class TooltipListener
    implements AncestorListener {
        private final Timer timer;
        private final MouseMotionListener mml;
        private final MouseListener ml;
        private Component focusOwner;
        private Double distance;

        public TooltipListener() {
            CustomTooltipSupport.this.content.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    TooltipListener.this.focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    CustomTooltipSupport.this.content.requestFocus(true);
                    TooltipListener.this.timer.stop();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TooltipListener.this.hideCustom();
                }
            });
            this.mml = new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Double newDistance = UIUtils.getDistance(e.getLocationOnScreen(), CustomTooltipSupport.this.content.getScreenBounds());
                    if (TooltipListener.this.distance != null) {
                        if (newDistance <= TooltipListener.this.distance) {
                            TooltipListener.this.timer.restart();
                        } else {
                            TooltipListener.this.timer.stop();
                            TooltipListener.this.hideCustom();
                            newDistance = null;
                        }
                    }
                    TooltipListener.this.distance = newDistance;
                }
            };
            this.ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TooltipListener.this.hideCustom();
                }
            };
            this.timer = new Timer(DELAY, e -> this.hideCustom());
            this.timer.setRepeats(false);
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            CustomTooltipSupport.this.content.setText(CustomTooltipSupport.this.text);
            CustomTooltipSupport.this.tooltip.getComponent().addMouseListener(this.ml);
            this.hideCustom();
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
            CustomTooltipSupport.this.tooltip.getComponent().removeMouseListener(this.ml);
            this.distance = null;
            this.showCustom();
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }

        private void showCustom() {
            CustomTooltipSupport.this.glassPanel.add(CustomTooltipSupport.this.content);
            CustomTooltipSupport.this.glassPanel.invalidate();
            CustomTooltipSupport.this.glassPanel.repaint();
            CustomTooltipSupport.this.glassPanel.addMouseMotionListener(this.mml);
            CustomTooltipSupport.this.tooltip.setVisible(false);
            this.timer.restart();
        }

        private void hideCustom() {
            this.timer.stop();
            CustomTooltipSupport.this.glassPanel.remove(CustomTooltipSupport.this.content);
            CustomTooltipSupport.this.glassPanel.invalidate();
            CustomTooltipSupport.this.glassPanel.repaint();
            CustomTooltipSupport.this.tooltip.setVisible(true);
            CustomTooltipSupport.this.glassPanel.removeMouseMotionListener(this.mml);
            if (this.focusOwner != null) {
                this.focusOwner.requestFocusInWindow();
            }
        }
    }

    private static final class TooltipContent
    extends JTextPane {
        public TooltipContent() {
            this.setContentType("text/html");
            this.setEditable(false);
            StyledDocument doc = this.getStyledDocument();
            HTMLDocument html = (HTMLDocument)doc;
            final Color tipBackgroundColor = UIManager.getColor("ToolTip.background");
            html.getStyleSheet().addRule("body { background-color:" + UIUtils.toHTMLColor(tipBackgroundColor) + "; }");
            html.getStyleSheet().addRule("table.tooltip { border-width:0; padding:0; border-collapse:collapse; }");
            html.getStyleSheet().addRule("table.tooltip td { white-space:nowrap; }");
            final LineBorder border = new LineBorder(Color.gray, 1);
            Insets insets = UIManager.getInsets("ToolTip.contentMargins");
            this.setBorder(new MatteBorder(insets, tipBackgroundColor){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setColor(tipBackgroundColor);
                    g2d.setStroke(new BasicStroke(8.0f));
                    g2d.drawRect(x, y, width, height);
                    g2d.dispose();
                    border.paintBorder(c, g, x, y, width, height);
                }
            });
            this.setOpaque(true);
        }

        @Override
        public String getSelectedText() {
            String txt = super.getSelectedText();
            return txt == null ? null : txt.replace(":\n", ":\t");
        }

        private Rectangle getScreenBounds() {
            Rectangle bounds = this.getBounds();
            bounds.setLocation(this.getLocationOnScreen());
            return bounds;
        }
    }
}

