/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.model.LogRecordElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.ui.ScrollBarUIEx;
import com.azul.log.model.api.LogRecord;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ListView
extends JPanel {
    private final JList<String> list;
    private DataRecordListModel model;
    private final UIElementSelectionModel tableSelectionModel;
    private final TableSelectionChangeListener tableSelectionChangeListener;

    public ListView(LogRecord record, UIElementSelectionModel selectionModel, Mode mode) {
        this.setLayout(new BorderLayout());
        this.model = new DataRecordListModel(record, mode);
        this.list = new JList<String>(this.model);
        this.list.setBorder(new EmptyBorder(2, 4, 2, 4));
        this.tableSelectionModel = selectionModel;
        this.list.setCellRenderer(new DataRecordListCellRenderer());
        this.tableSelectionChangeListener = new TableSelectionChangeListener();
        JScrollPane scrollPane = new JScrollPane(this.list);
        ScrollBarUIEx.setup(scrollPane, false);
        this.add((Component)scrollPane, "Center");
    }

    public void updateRecords(LogRecord newRecord) {
        this.model = new DataRecordListModel(newRecord, this.model.getMode());
        this.list.setModel(this.model);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.installListeners();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
    }

    private void installListeners() {
        this.tableSelectionModel.addChangeListener(this.tableSelectionChangeListener);
    }

    private void uninstallListeners() {
        this.tableSelectionModel.removeChangeListener(this.tableSelectionChangeListener);
    }

    public static enum Mode {
        RESERVED,
        COMMITTED;

    }

    private static class DataRecordListCellRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        public DataRecordListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value);
            Color background = isSelected ? Color.lightGray : Color.WHITE;
            Color foreground = Color.BLACK;
            this.setBackground(background);
            this.setForeground(foreground);
            this.setBorder(new EmptyBorder(2, 0, 2, 0));
            return this;
        }
    }

    private static class DataRecordListModel
    extends AbstractListModel<String> {
        private final Mode mode;
        private final LogRecord record;
        private final List<Field> fields;

        public Mode getMode() {
            return this.mode;
        }

        public DataRecordListModel(LogRecord record, Mode mode) {
            this.record = record;
            this.mode = mode;
            this.fields = record == null ? Collections.emptyList() : record.getAllFields();
        }

        @Override
        public int getSize() {
            Object[] values = this.getRecordValues();
            if (this.mode == Mode.COMMITTED && values.length > 4) {
                Object list = values[4];
                try {
                    return (Integer)list.getClass().getDeclaredMethod("size", new Class[0]).invoke(list, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return 1;
        }

        @Override
        public String getElementAt(int index) {
            Object[] values = this.getRecordValues();
            if (this.mode == Mode.COMMITTED) {
                LogRecord data;
                Object list = values[4];
                try {
                    data = (LogRecord)list.getClass().getDeclaredMethod("getRecord", Integer.TYPE).invoke(list, index);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                if (data != null) {
                    try {
                        return (String)data.getClass().getDeclaredMethod("getHTMLRepresentation", new Class[0]).invoke((Object)data, new Object[0]);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
            try {
                return (String)this.record.getClass().getDeclaredMethod("getHTMLRepresentation", new Class[0]).invoke((Object)this.record, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private Object[] getRecordValues() {
            return this.fields.stream().map(this.record::getFieldValue).toArray();
        }
    }

    private class TableSelectionChangeListener
    implements ChangeListener {
        private TableSelectionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ListView.this.tableSelectionModel.getSelectedElement() instanceof LogRecordElement) {
                LogRecordElement record = (LogRecordElement)ListView.this.tableSelectionModel.getSelectedElement();
                ListView.this.updateRecords(record.getLogRecord());
            }
        }
    }
}

