/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.AboutAction;
import com.azul.log.gui.actions.ItemSelectionActions;
import com.azul.log.gui.actions.MarksActions;
import com.azul.log.gui.actions.NameWindowAction;
import com.azul.log.gui.actions.NewWindowAction;
import com.azul.log.gui.actions.OpenFileAction;
import com.azul.log.gui.actions.SearchTextActions;
import com.azul.log.gui.actions.SnapshotAction;
import com.azul.log.gui.actions.SnapshotToClipboardAction;
import com.azul.log.gui.actions.TimeAdjustmentAction;
import com.azul.log.gui.actions.ViewAdviceAction;
import com.azul.log.gui.actions.ViewLogAction;
import com.azul.log.gui.actions.ViewLogSummaryAction;
import com.azul.log.gui.actions.spi.LaunchCommandProvider;
import com.azul.log.gui.actions.spi.MenuEntriesProvider;
import com.azul.log.gui.arguments.UIParams;
import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.api.PlotData;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.GraphsSelectorModel;
import com.azul.log.gui.model.ScratchpadModel;
import com.azul.log.gui.model.TimeRange;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.model.VisibleValueRangeModel;
import com.azul.log.gui.model.support.AbstractModel;
import com.azul.log.gui.support.OpenFileSupport;
import com.azul.log.gui.support.UndoSupport;
import com.azul.log.gui.tables.api.TableData;
import com.azul.log.gui.tables.api.TableDefinition;
import com.azul.log.gui.ui.ContentPanel;
import com.azul.log.gui.ui.DisplayTimeUnitsSelector;
import com.azul.log.gui.ui.GraphPanel;
import com.azul.log.gui.ui.GraphSelectionPanel;
import com.azul.log.gui.ui.InfoPanel;
import com.azul.log.gui.ui.NMT_Panel;
import com.azul.log.gui.ui.OpenFileButtonPanel;
import com.azul.log.gui.ui.PersistentJSplitPane;
import com.azul.log.gui.ui.PlotSeriesSelector;
import com.azul.log.gui.ui.RecentFilesSelector;
import com.azul.log.gui.ui.ScratchpadPanel;
import com.azul.log.gui.ui.StatusBar;
import com.azul.log.gui.ui.TablePanel;
import com.azul.log.gui.ui.TableSelectionPanel;
import com.azul.log.gui.ui.TimeSelectionPanel;
import com.azul.log.gui.ui.ViewsNavigationPanel;
import com.azul.log.gui.ui.VisibleMarklinesSelector;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.gui.utils.jfreechart.PlotSeriesVisibilitySupport;
import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogFilesModel;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogTimeModel;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.spi.Destroyable;
import com.azul.log.utils.ChangeSupport;
import com.azul.log.utils.CommonUtils;
import com.azul.log.utils.ProgressModel;
import io.netty.util.internal.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.jfree.data.Range;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class MainFrame
extends JFrame {
    private static MainFrame instance;
    private final Lookup configLookup;
    private final ProxyLookup.Controller contentPanelLookupController;
    private final Lookup contentPanelLookup;
    private final ProxyLookup.Controller timeModelLookupController;
    private final ProxyLookup timeModelLookup;
    private final OpenFileSupport.LogFilesOpenHandler openLogsHandler;
    private final OpenFileSupport.LogFilesOpenHandler addLogsHandler;
    private final Lookup.Result<GraphDefinition> graphSelectionResult;
    private final Lookup.Result<TableDefinition> tableSelectionResult;
    private final Lookup.Result<LogModel> logModelLookupResult;
    private final GraphSelectionPanel graphSelectionPanel;
    private final TableSelectionPanel tableSelectionPanel;
    private final OpenFileButtonPanel openFileButtonPanel;
    private final ScratchpadPanel scratchpadPanel;
    private final JPanel contentPanel;
    private final JPanel buttonsPanel;
    private final JRadioButtonMenuItem experimentalAutoAnalysisSelector;

    private MainFrame(Lookup configLookup) throws HeadlessException {
        this.configLookup = configLookup;
        this.contentPanelLookupController = new ProxyLookup.Controller();
        this.contentPanelLookup = new ProxyLookup(this.contentPanelLookupController);
        this.timeModelLookupController = new ProxyLookup.Controller();
        this.timeModelLookup = new ProxyLookup(this.timeModelLookupController);
        this.graphSelectionPanel = new GraphSelectionPanel();
        this.tableSelectionPanel = new TableSelectionPanel();
        this.contentPanel = new JPanel();
        this.scratchpadPanel = new ScratchpadPanel();
        this.openLogsHandler = (logFiles, error) -> {
            if (error == null) {
                this.open((List<LogFile>)logFiles);
            } else if (!error.isEmpty()) {
                JOptionPane.showMessageDialog(this, error, "Error", 0);
            }
        };
        this.addLogsHandler = (logFiles, error) -> {
            if (error == null) {
                this.openMore((List<LogFile>)logFiles);
            } else if (!error.isEmpty()) {
                JOptionPane.showMessageDialog(this, error, "Error", 0);
            }
        };
        this.openFileButtonPanel = new OpenFileButtonPanel(this.openLogsHandler);
        this.buttonsPanel = new JPanel(new FlowLayout(1, 0, 0));
        this.experimentalAutoAnalysisSelector = new JRadioButtonMenuItem("Enable Experimental Mode");
        this.initComponents();
        this.enableEvents(1L);
        this.setIconImages(UIUtils.loadImages("/azlogo/16x16.png", "/azlogo/32x32.png", "/azlogo/48x48.png", "/azlogo/128x128.png"));
        this.initMenu();
        this.initToolbar();
        this.bindActions();
        this.graphSelectionPanel.setPeerPanel(this.tableSelectionPanel);
        this.tableSelectionPanel.setPeerPanel(this.graphSelectionPanel);
        this.graphSelectionResult = Context.lookupResult(GraphDefinition.class);
        this.tableSelectionResult = Context.lookupResult(TableDefinition.class);
        this.logModelLookupResult = Context.lookupResult(LogModel.class);
        this.setupDragNDrop();
        Rectangle bounds = this.decodeRectangle(Config.getProperty("WindowBounds"));
        if (bounds == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dim = toolkit.getScreenSize();
            bounds = new Rectangle(dim.width * 8 / 100, dim.height * 4 / 100, dim.width * 80 / 100, dim.height * 80 / 100);
        }
        this.setBounds(bounds);
    }

    static void createAndShow(Lookup lookup) {
        instance = new MainFrame(lookup);
        instance.setVisible(true);
        UIParams params = lookup.lookup(UIParams.class);
        if (params != null && !params.uris.isEmpty()) {
            new OpenFileAction(params.uris, MainFrame.instance.openLogsHandler).actionPerformed(null);
        }
    }

    public static MainFrame get() {
        return instance;
    }

    private void open(List<LogFile> logFiles) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new InternalError();
        }
        if (logFiles.isEmpty()) {
            Context.setContext(this.configLookup);
            return;
        }
        long nonMetricsModels = logFiles.stream().map(f -> f.lookup(LogModel.class)).filter(m -> !Arrays.asList("Metrics", "RN", "VM").contains(m.getModelID())).count();
        if (nonMetricsModels > 1L) {
            JOptionPane.showMessageDialog(this, "Multiple logs (other than .metrics or RN or VM files) cannot be opened simultaneously", "Error", 0);
            return;
        }
        this.createPlotData(logFiles, () -> {
            LogTimeModel compoundTimeModel = LogTimeModel.getCompoundLogTimeModelAndFixupLogModels(logFiles);
            this.cleanupContext(logFiles);
            this.setContentPanel(null);
            PlotSeriesVisibilitySupport.reset();
            ScratchpadModel.getModel().reset(this.scratchpadPanel);
            UIElementSelectionModel.getInstance().clearSelection();
            this.updateTimeModelLookup(compoundTimeModel);
            Context.setContext(new ProxyLookup(Lookups.fixed(new LogFilesModel(logFiles), ValueRangeSelectionModelImpl.create(), MarksModel.create(logFiles)), this.timeModelLookup, this.configLookup, this.contentPanelLookup, this.graphSelectionPanel.getLookup(), this.tableSelectionPanel.getLookup(), UIElementSelectionModel.getInstance().getLookup()));
            SwingUtilities.invokeLater(() -> new ViewLogSummaryAction().actionPerformed((ActionEvent)null));
        });
    }

    private void updateTimeModelLookup(LogTimeModel compoundTimeModel) {
        this.timeModelLookupController.setLookups(Lookups.fixed(DisplayTimeModel.create(compoundTimeModel), VisibleTimeRangeModelImpl.create(compoundTimeModel), SelectedTimeRangeModelImpl.create(compoundTimeModel)));
    }

    public void refreshTimeModel() {
        List<LogFile> logFiles = Context.lookup(LogFilesModel.class).getLogFiles();
        this.updateTimeModelLookup(LogTimeModel.getCompoundLogTimeModelAndFixupLogModels(logFiles));
    }

    private void cleanupContext(List<LogFile> logFiles) {
        HashSet<Destroyable> toDestroy = new HashSet<Destroyable>();
        LogFilesModel logFilesModel = Context.lookup(LogFilesModel.class);
        if (logFilesModel != null) {
            toDestroy.addAll(logFilesModel.lookupAll(Destroyable.class));
        }
        toDestroy.addAll(Context.lookupAll(Destroyable.class));
        Collection destroyableInFilesToOpen = logFiles.stream().map(f -> f.lookup(Destroyable.class)).collect(Collectors.toList());
        toDestroy.stream().filter(CommonUtils.not(destroyableInFilesToOpen::contains)).forEach(Destroyable::destroy);
    }

    private void openMore(List<LogFile> logFiles) {
        List opened = Optional.ofNullable(Context.lookup(LogFilesModel.class)).map(LogFilesModel::getLogFiles).orElse(Collections.emptyList());
        List<LogFile> all = Stream.of(logFiles, opened).flatMap(Collection::stream).collect(Collectors.toList());
        this.open(all);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.updateProperty();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.updateProperty();
            }

            private void updateProperty() {
                Config.setProperty("WindowBounds", MainFrame.this.encodeRectangle(MainFrame.this.getBounds()));
            }
        });
    }

    private void setupDragNDrop() throws HeadlessException {
        this.setDropTarget(new DropTarget(this.getRootPane(), new DropTargetHandler()));
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        JPanel centerPanel = new JPanel();
        centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        centerPanel.setLayout(new BorderLayout());
        JSplitPane topSplitPane = new JSplitPane();
        topSplitPane.setBorder(null);
        topSplitPane.setDividerSize(0);
        JLabel logo = new JLabel();
        ImageIcon icon = UIUtils.scaledImage("/logo.png", 0, 48);
        logo.setIcon(icon);
        logo.setBorder(new EmptyBorder(0, 15, 0, 0));
        JPanel logoPanel = new JPanel();
        logoPanel.add(UIUtils.autoScale(logo));
        JPanel leftHeaderPanel = new JPanel(new BorderLayout());
        leftHeaderPanel.add((Component)logoPanel, "West");
        ViewsNavigationPanel.setGraphSelectionPanel(this.graphSelectionPanel);
        leftHeaderPanel.add((Component)ViewsNavigationPanel.getInstance(), "After");
        topSplitPane.setLeftComponent(leftHeaderPanel);
        topSplitPane.setRightComponent(this.createToolbar());
        centerPanel.add((Component)topSplitPane, "First");
        PersistentJSplitPane vSplitPane = new PersistentJSplitPane("vSplitPane");
        vSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        vSplitPane.setDividerSize(6);
        this.synchronizeSplitPanels(vSplitPane, topSplitPane);
        PersistentJSplitPane hSplitPane = new PersistentJSplitPane("hSplitPane", Integer.MAX_VALUE);
        hSplitPane.setBorder(null);
        hSplitPane.setDividerSize(6);
        hSplitPane.setOrientation(0);
        hSplitPane.setResizeWeight(1.0);
        this.graphSelectionPanel.setPeerPanel(this.tableSelectionPanel);
        hSplitPane.setTopComponent(this.graphSelectionPanel);
        this.tableSelectionPanel.setMinimumSize(new Dimension(13, 0));
        this.tableSelectionPanel.setPeerPanel(this.graphSelectionPanel);
        hSplitPane.setBottomComponent(this.tableSelectionPanel);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)hSplitPane, "Center");
        vSplitPane.setLeftComponent(leftPanel);
        this.contentPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.openFileButtonPanel, "Center");
        vSplitPane.setRightComponent(this.contentPanel);
        this.contentPanel.getAccessibleContext().setAccessibleParent(vSplitPane);
        hSplitPane.setMinimumSize(new Dimension(logo.getPreferredSize().width, 0));
        topSplitPane.setDividerLocation(logo.getPreferredSize().width);
        centerPanel.add((Component)vSplitPane, "Center");
        InfoPanel infoPanel = new InfoPanel();
        infoPanel.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)));
        infoPanel.setPreferredSize(new Dimension(2, 50));
        centerPanel.add((Component)infoPanel, "Last");
        int fontHeight = infoPanel.getFont().getSize();
        infoPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, fontHeight * 4));
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)new StatusBar(), "Last");
        this.setJMenuBar(new JMenuBar());
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        switch (e.getID()) {
            case 102: {
                this.registerListeners();
                break;
            }
            case 103: {
                this.unregisterListeners();
                break;
            }
        }
        super.processComponentEvent(e);
    }

    private boolean isNMTView(TableDefinition td) {
        return td.getTitle().equals("Mmap") || td.getTitle().equals("Malloc");
    }

    private void registerListeners() {
        this.graphSelectionResult.addLookupListener(e -> {
            GraphDefinition gd = this.graphSelectionPanel.getLookup().lookup(GraphDefinition.class);
            if (gd != null) {
                if (this.graphSelectionPanel.renderScratchpadSelected()) {
                    this.scratchpadPanel.handleSelection(gd);
                    this.setContentPanel(this.scratchpadPanel);
                    return;
                }
                this.setContentPanel(GraphPanel.create(gd));
                ViewsNavigationPanel.graphSelectionChangeHandler();
            }
        });
        this.tableSelectionResult.addLookupListener(e -> {
            TableDefinition td = this.tableSelectionPanel.getLookup().lookup(TableDefinition.class);
            if (td != null) {
                if (this.isNMTView(td)) {
                    this.setContentPanel(NMT_Panel.create(td));
                } else {
                    this.setContentPanel(TablePanel.create(td));
                }
            }
        });
        LookupListener modelListener = e -> {
            LogModel logModel = Context.lookup(LogModel.class);
            String customWindowTitle = NameWindowAction.getTitle();
            this.setTitle(!StringUtil.isNullOrEmpty(customWindowTitle) ? customWindowTitle : (logModel == null ? "Azul Log Analyzer" : logModel.getLogName()));
        };
        this.logModelLookupResult.addLookupListener(modelListener);
        modelListener.resultChanged(null);
        ViewLogAction.getButton().addActionListener(e -> ViewsNavigationPanel.logViewSelectionHandler());
        ViewLogSummaryAction.getButton().addActionListener(e -> ViewsNavigationPanel.infoViewSelectionHandler());
    }

    private void unregisterListeners() {
    }

    public void setContentPanel(ContentPanel content) {
        this.contentPanel.removeAll();
        this.contentPanel.add((Component)(content == null ? this.openFileButtonPanel : content), "Center");
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        this.contentPanelLookupController.setLookups(content == null ? Lookup.EMPTY : content.getLookup());
    }

    private void synchronizeSplitPanels(JSplitPane ... panes) {
        PropertyChangeListener listener = e -> {
            Object source = e.getSource();
            int location = (Integer)e.getNewValue();
            for (JSplitPane pane : panes) {
                if (source == pane) continue;
                pane.setDividerLocation(location);
            }
        };
        int location = panes[0].getDividerLocation();
        for (JSplitPane pane : panes) {
            pane.setDividerLocation(location);
        }
        for (JSplitPane pane : panes) {
            pane.addPropertyChangeListener("dividerLocation", listener);
        }
    }

    private void initMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(NewWindowAction.getMenuPresenter());
        fileMenu.add(new JPopupMenu.Separator());
        fileMenu.add(OpenFileAction.getMenuPresenter(OpenFileAction.TYPE.OPEN, this.openLogsHandler));
        fileMenu.add(OpenFileAction.getMenuPresenter(OpenFileAction.TYPE.ADD, this.addLogsHandler));
        JMenuItem quitMenuItem = new JMenuItem("Quit");
        quitMenuItem.addActionListener(evt -> System.exit(0));
        quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, UIUtils.MENU_SHORTCUT_KEY_MASK));
        fileMenu.add(quitMenuItem);
        menuBar.add(fileMenu);
        fileMenu.insert(new RecentFilesSelector(this.openLogsHandler), 3);
        JMenu viewMenu = new JMenu("View");
        viewMenu.add(new DisplayTimeUnitsSelector());
        JMenu graphsSelectorMenu = new JMenu("Graphs");
        graphsSelectorMenu.add(GraphsSelectorModel.allGraphs);
        graphsSelectorMenu.add(GraphsSelectorModel.favoriteGraphs);
        graphsSelectorMenu.add(GraphsSelectorModel.scratchpad);
        graphsSelectorMenu.add(new JSeparator());
        graphsSelectorMenu.add(GraphsSelectorModel.enumerateGraphsAction.getMenuPresenter());
        viewMenu.add(graphsSelectorMenu);
        viewMenu.add(this.experimentalAutoAnalysisSelector);
        viewMenu.add(new JPopupMenu.Separator());
        viewMenu.add(NameWindowAction.getMenuPresenter());
        menuBar.add(viewMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.add(UndoSupport.getMenuPresenter(UndoSupport.UNDO));
        editMenu.add(UndoSupport.getMenuPresenter(UndoSupport.REDO));
        editMenu.add(new JPopupMenu.Separator());
        editMenu.add(SearchTextActions.getMenuPresenter(SearchTextActions.FIND));
        editMenu.add(SearchTextActions.getMenuPresenter(SearchTextActions.FIND_NEXT));
        editMenu.add(SearchTextActions.getMenuPresenter(SearchTextActions.FIND_PREV));
        editMenu.add(MarksActions.getMenuPresenter());
        editMenu.add(new JPopupMenu.Separator());
        editMenu.add(SnapshotToClipboardAction.getMenuPresenter());
        menuBar.add(editMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(AboutAction.getMenuPresenter());
        menuBar.add(helpMenu);
        Collection<MenuEntriesProvider> providers = Context.lookupAll(MenuEntriesProvider.class);
        providers.stream().map(MenuEntriesProvider::getEntries).flatMap(Collection::stream).forEach(e -> {
            JMenu menu = this.findOrCreateMenu(e.getPath());
            menu.insert(e.getMenuItem(), e.getPosition());
        });
        providers.forEach(provider -> provider.getEntries().forEach(e -> {
            JMenu menu = this.findOrCreateMenu(e.getPath());
            menu.insert(e.getMenuItem(), e.getPosition());
        }));
    }

    private JMenu findOrCreateMenu(String path) {
        JComponent container = this.getJMenuBar();
        for (String text : path.split("/")) {
            boolean found = false;
            for (Component component : container.getComponents()) {
                JMenu m;
                if (!(component instanceof JMenu) || !text.equals((m = (JMenu)component).getText())) continue;
                container = m;
                found = true;
                break;
            }
            if (found) continue;
            JMenu m = new JMenu(text);
            container.add(m);
            container = m;
        }
        assert (container instanceof JMenu);
        return (JMenu)container;
    }

    private void bindActions() {
        JRootPane pane = this.getRootPane();
        ActionMap actionMap = pane.getActionMap();
        InputMap inputMap = pane.getInputMap(1);
        ItemSelectionActions.registerActions(actionMap, inputMap);
        MarksActions.registerActions(actionMap, inputMap);
        final ViewLogAction viewLogAction = new ViewLogAction();
        AbstractAction viewLog = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                viewLogAction.openLog(this.getSelectedElement().getLogModel());
                ViewsNavigationPanel.logViewSelectionHandler();
            }

            @Override
            public boolean isEnabled() {
                return this.getSelectedElement() != null;
            }

            private UIElement getSelectedElement() {
                return UIElementSelectionModel.getInstance().getSelectedElement();
            }
        };
        pane.registerKeyboardAction(viewLog, "viewLog", KeyStroke.getKeyStroke(10, 64), 1);
        pane.registerKeyboardAction(SearchTextActions.FIND, "find", KeyStroke.getKeyStroke(47, 0), 1);
        pane.registerKeyboardAction(ViewsNavigationPanel.getGoToPrevViewAction(), "goToPreviousView", ViewsNavigationPanel.GO_TO_PREV_KEY, 1);
        pane.registerKeyboardAction(ViewsNavigationPanel.getGoToNextViewAction(), "goToNextView", ViewsNavigationPanel.GO_TO_NEXT_KEY, 1);
    }

    private Rectangle decodeRectangle(String str) {
        if (str != null) {
            try {
                String[] split = str.split("x");
                if (split.length == 4) {
                    return new Rectangle(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private String encodeRectangle(Rectangle rect) {
        return rect.x + "x" + rect.y + "x" + rect.width + "x" + rect.height;
    }

    private Component createToolbar() {
        JPanel toolbar = new JPanel(new BorderLayout());
        JPanel helperPanel = new JPanel(new GridBagLayout());
        helperPanel.add((Component)new TimeSelectionPanel(), new GridBagConstraints());
        toolbar.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 1));
        toolbar.add((Component)helperPanel, "West");
        toolbar.add((Component)this.buttonsPanel, "After");
        return toolbar;
    }

    private void initToolbar() {
        Dimension d = new Dimension(10, 10);
        this.buttonsPanel.add(ViewLogSummaryAction.getToolbarPresenter());
        this.buttonsPanel.add(ViewAdviceAction.getToolbarPresenter());
        this.buttonsPanel.add(ViewLogAction.getToolbarPresenter());
        this.buttonsPanel.add(TimeAdjustmentAction.getToolbarPresenter());
        this.buttonsPanel.add(ItemSelectionActions.getToolbarPresenter(ItemSelectionActions.PREVIOUS));
        this.buttonsPanel.add(ItemSelectionActions.getToolbarPresenter(ItemSelectionActions.NEXT));
        this.buttonsPanel.add(new PlotSeriesSelector());
        this.buttonsPanel.add(new Box.Filler(d, d, d));
        this.buttonsPanel.add(MarksActions.getToolbarPresenter());
        this.buttonsPanel.add(new VisibleMarklinesSelector());
        this.buttonsPanel.add(new Box.Filler(d, d, d));
        this.buttonsPanel.add(SnapshotAction.getToolbarPresenter());
        this.experimentalAutoAnalysisSelector.setVisible(false);
        for (Component c : this.buttonsPanel.getComponents()) {
            c.setFocusable(false);
        }
    }

    private void createPlotData(final List<LogFile> logFiles, final Runnable continuation) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new InternalError();
        }
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        JOptionPane pane = new JOptionPane(new Object[]{"Initializing data", progressBar}, 1, -1, null, new Object[0], null);
        final JDialog progressDialog = pane.createDialog(MainFrame.get(), "Progress ...");
        progressDialog.setModal(false);
        progressDialog.setAlwaysOnTop(true);
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setFocusable(true);
        progressDialog.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                e.consume();
            }
        });
        progressDialog.toFront();
        progressDialog.setVisible(true);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                logFiles.forEach(logFile -> {
                    LogModel model = logFile.getLookup().lookup(LogModel.class);
                    if (model != null) {
                        PlotData plotData = PlotData.create(model, new ProgressModel());
                        logFile.getInstanceContext().add(plotData);
                        logFile.getInstanceContext().add(TableData.create(model));
                    }
                });
                return null;
            }

            @Override
            protected void done() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
                try {
                    continuation.run();
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
        };
        worker.execute();
    }

    private static enum LogOpenOptions {
        OPEN_IN_NEW_WINDOW("Open in New Window"),
        OPEN_IN_CUR_WINDOW("Open in Current Window"),
        MERGE_IN_CUR_WINDOW("Merge in Current Window");

        final String text;

        private LogOpenOptions(String label) {
            this.text = label;
        }

        public String toString() {
            return this.text;
        }
    }

    private class DropTargetHandler
    extends DropTargetAdapter {
        private final Color c1 = Color.gray;
        private final Color c2 = Color.green;

        private DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            Border border = BorderFactory.createLineBorder(this.c2);
            MainFrame.this.contentPanel.setBorder(border);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            MainFrame.this.contentPanel.setBorder(BorderFactory.createLineBorder(this.c1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dtde) {
            int actions = dtde.getSourceActions();
            dtde.acceptDrop(actions);
            Transferable transferable = dtde.getTransferable();
            ArrayList<URI> uriList = new ArrayList<URI>();
            try {
                Object obj2;
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        obj2 = transferable.getTransferData(DataFlavor.stringFlavor);
                        if (obj2 instanceof String) {
                            uriList.addAll(Arrays.stream(String.valueOf(obj2).split("\n")).map(String::trim).map(URI::create).collect(Collectors.toList()));
                        }
                    }
                    catch (UnsupportedFlavorException | IOException obj2) {}
                } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    try {
                        obj2 = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        if (obj2 instanceof List) {
                            uriList.addAll(((List)obj2).stream().filter(File.class::isInstance).map(File.class::cast).map(File::toURI).collect(Collectors.toList()));
                        }
                    }
                    catch (UnsupportedFlavorException | IOException obj3) {
                        // empty catch block
                    }
                }
                OpenFileSupport.LogFilesOpenHandler handler = MainFrame.this.openLogsHandler;
                if (!uriList.isEmpty()) {
                    boolean isNonEmptyGCLAContext;
                    boolean bl = isNonEmptyGCLAContext = Context.lookup(LogModel.class) != null;
                    if (isNonEmptyGCLAContext) {
                        int response = JOptionPane.showOptionDialog(MainFrame.get(), "Where would you like to open the log ?", "Open log", -1, 3, null, (Object[])LogOpenOptions.values(), (Object)LogOpenOptions.values()[0]);
                        switch (LogOpenOptions.values()[response]) {
                            case OPEN_IN_NEW_WINDOW: {
                                Optional<LaunchCommandProvider> launchCommandProvider = Optional.ofNullable(Context.lookup(LaunchCommandProvider.class));
                                launchCommandProvider.ifPresent(launchCmd -> {
                                    try {
                                        ArrayList<String> command = new ArrayList<String>(launchCmd.getCommand());
                                        command.addAll(uriList.stream().map(URI::getPath).collect(Collectors.toList()));
                                        ProcessBuilder pb = new ProcessBuilder(command);
                                        pb.inheritIO();
                                        pb.start();
                                    }
                                    catch (IOException ex) {
                                        Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                });
                                return;
                            }
                            case OPEN_IN_CUR_WINDOW: {
                                handler = MainFrame.this.openLogsHandler;
                                break;
                            }
                            case MERGE_IN_CUR_WINDOW: {
                                handler = MainFrame.this.addLogsHandler;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    OpenFileAction action = new OpenFileAction(uriList, handler);
                    SwingUtilities.invokeLater(() -> action.actionPerformed(null));
                }
            }
            finally {
                dtde.dropComplete(true);
                MainFrame.this.contentPanel.setBorder(BorderFactory.createLineBorder(this.c1));
            }
        }
    }

    private static final class ValueRangeSelectionModelImpl
    extends AbstractModel
    implements VisibleValueRangeModel {
        private final Map<Integer, Range> map = new HashMap<Integer, Range>();

        private ValueRangeSelectionModelImpl() {
        }

        public static VisibleValueRangeModel create() {
            return new ValueRangeSelectionModelImpl();
        }

        @Override
        public void setVisibleValueRange(int graphID, Range range) {
            this.map.put(graphID, range);
        }

        @Override
        public Range getVisibleValueRange(int graphID) {
            return this.map.get(graphID);
        }
    }

    private static class SelectedTimeRangeModelImpl
    implements TimeRangeSelectionModel.SelectedTimeRangeModel {
        private final ChangeSupport cs = new ChangeSupport(this);
        private final LogTimeModel logTimeModel;
        private TimeRange selection;

        private SelectedTimeRangeModelImpl(LogTimeModel model) {
            this.logTimeModel = model;
        }

        public static SelectedTimeRangeModelImpl create(LogTimeModel model) {
            return new SelectedTimeRangeModelImpl(model);
        }

        @Override
        public TimeRange getSelection() {
            return this.selection;
        }

        @Override
        public void setSelection(TimeRange selection) {
            this.selection = selection;
            this.cs.fireChange();
        }

        @Override
        public long getMaximum(TimeUnit units) {
            return this.logTimeModel.getLastEventRelativeTimestamp().getInUnits(units);
        }

        @Override
        public long getMinimum(TimeUnit units) {
            return this.logTimeModel.getFirstEventRelativeTimestamp().getInUnits(units);
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }
    }

    private static final class VisibleTimeRangeModelImpl
    extends DefaultBoundedRangeModel
    implements TimeRangeSelectionModel.VisibleTimeRangeModel {
        private final TimeUnit rangeUnits;
        private final TimeRange wholeRange;

        private VisibleTimeRangeModelImpl(LogTimeModel model) {
            TimeRange dataRange = new TimeRange(model.getFirstEventRelativeTimestamp(), model.getLastEventRelativeTimestamp());
            this.rangeUnits = this.getSmallestUnitForRange(dataRange);
            RelativeTimestamp start = dataRange.getStart();
            int v_min = start == null ? 0 : (int)start.getInUnits(this.rangeUnits);
            this.setMinimum(v_min);
            RelativeTimestamp end = dataRange.getEnd();
            int v_max = end == null ? 0 : (int)(this.rangeUnits.convert(1L, TimeUnit.SECONDS) + end.getInUnits(this.rangeUnits));
            this.setMaximum(v_max);
            this.wholeRange = new TimeRange(v_min, v_max, this.rangeUnits);
            this.selectAll();
        }

        public static TimeRangeSelectionModel.VisibleTimeRangeModel create(LogTimeModel model) {
            return new VisibleTimeRangeModelImpl(model);
        }

        @Override
        public TimeRange getSelection() {
            return new TimeRange(this.getValue(), this.getValue() + this.getExtent(), this.rangeUnits);
        }

        @Override
        public void setSelection(TimeRange selection) {
            int start = (int)selection.getStart().getInUnits(this.rangeUnits);
            int end = (int)selection.getEnd().getInUnits(this.rangeUnits);
            this.setRangeProperties(start, end - start, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
        }

        @Override
        public long getMaximum(TimeUnit units) {
            return units.convert(this.getMaximum(), this.rangeUnits);
        }

        @Override
        public long getMinimum(TimeUnit units) {
            return units.convert(this.getMinimum(), this.rangeUnits);
        }

        @Override
        public void selectAll() {
            this.setSelection(this.wholeRange);
        }

        private TimeUnit getSmallestUnitForRange(TimeRange range) {
            if (range.getEnd() == null) {
                return TimeUnit.MILLISECONDS;
            }
            if (1000L + range.getEnd().getInUnits(TimeUnit.MILLISECONDS) < Integer.MAX_VALUE) {
                return TimeUnit.MILLISECONDS;
            }
            if (1L + range.getEnd().getInUnits(TimeUnit.SECONDS) < Integer.MAX_VALUE) {
                return TimeUnit.SECONDS;
            }
            Logger.getLogger(VisibleTimeRangeModelImpl.class.getName()).log(Level.SEVERE, "Unbelievably large range {0}", range);
            return TimeUnit.MINUTES;
        }

        @Override
        public boolean isAdjusting() {
            return this.getValueIsAdjusting();
        }

        @Override
        public boolean isWholeRange() {
            return this.wholeRange.equals(this.getSelection());
        }
    }
}

