/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.markup.impl.TextHighlightProvider;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.LogRecordElement;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.search.NMT_TableFilterer;
import com.azul.log.gui.tables.api.TableDefinition;
import com.azul.log.gui.ui.NMT_SearchPanel;
import com.azul.log.gui.ui.TableViewBase;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.RelativeTimestamp;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class NMT_TableView
extends TableViewBase {
    private final DisplayTimeModel displayTimeModel = Context.lookup(DisplayTimeModel.class);
    private final TableDefinition td;
    private final NMT_SearchPanel searchPanel;
    private final ChangeListener searchChangeListener;
    private SearchFilterTask searchFilterTask;
    private final NMT_TableFilterer<TableModel> tableFilterer;
    private final Runnable tableUpdateAction;

    public NMT_TableView(TableDefinition td) {
        super(td, new ConverterImpl(td), td.getLogModel());
        this.td = td;
        this.table.setRowSorter(null);
        this.table.getTableHeader().setDefaultRenderer(new HeaderRendererImpl(this.table.getTableHeader().getDefaultRenderer()));
        this.table.setDefaultRenderer(Object.class, new CellRendererImpl());
        this.searchPanel = new NMT_SearchPanel(this.table);
        this.searchPanel.setVisible(true);
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(70, UIUtils.MENU_SHORTCUT_KEY_MASK);
        inputMap.put(keyStroke, "searchPanelToggle");
        actionMap.put("searchPanelToggle", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMT_TableView.this.searchPanel.setVisible(!NMT_TableView.this.searchPanel.isVisible());
            }
        });
        this.tableUpdateAction = () -> {
            this.table.revalidate();
            this.table.repaint();
            this.updateRowHeader();
            this.setColumnWidths();
        };
        this.tableFilterer = new NMT_TableFilterer<TableModel>(this.table.getModel(), this.searchPanel, this.tableUpdateAction, td.getTitle());
        this.searchChangeListener = e -> {
            if (this.searchFilterTask != null) {
                this.searchFilterTask.cancel();
            }
            boolean isSearchTextAvailable = this.searchPanel.getCompositeSearchBar().isSearchTextAvailable();
            if (!this.searchPanel.isVisible()) {
                TextHighlightProvider.reset();
                if (this.isLogViewFiltered()) {
                    this.table.setRowSorter(null);
                } else {
                    this.tableUpdateAction.run();
                }
                return;
            }
            if (this.searchPanel.applyFiltering() && isSearchTextAvailable) {
                this.table.setRowSorter(this.tableFilterer);
                this.searchFilterTask = new SearchFilterTask();
            } else {
                this.table.setRowSorter(null);
            }
            if (isSearchTextAvailable) {
                TextHighlightProvider.setContext(this.searchPanel.getSearchContext(), this.searchPanel.isCaseSensitive());
            } else {
                TextHighlightProvider.reset();
            }
            this.tableUpdateAction.run();
        };
        this.setColumnWidths();
        this.add((Component)this.searchPanel, "South");
    }

    @Override
    public LogRecord getRecordAtRow(int row) {
        return this.td.getRecord(row);
    }

    @Override
    protected void installListeners() {
        this.searchPanel.addChangeListener(this.searchChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.searchPanel.removeChangeListener(this.searchChangeListener);
    }

    @Override
    protected int getRowFor(UIElement selection) {
        int lineNumber = this.td.getRowWithoutTimestamp(selection.getLogLineNumber());
        return lineNumber >= 0 ? lineNumber : -1;
    }

    @Override
    protected RelativeTimestamp getRelativeTimestampForRow(int line) {
        return (RelativeTimestamp)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(line), 0);
    }

    private void setColumnWidths() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int width = 60;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            TableCellRenderer renderer = this.table.getCellRenderer(i, 0);
            Component comp = this.table.prepareRenderer(renderer, i, 0);
            width = Math.max(comp.getPreferredSize().width + 1, width);
        }
        columnModel.getColumn(0).setPreferredWidth(width += 20);
        columnModel.getColumn(0).setMaxWidth(width);
        this.table.setAutoResizeMode(2);
    }

    private static class ConverterImpl
    implements TableViewBase.TableRowToInfoConvertor {
        private final TableDefinition td;

        public ConverterImpl(TableDefinition td) {
            this.td = td;
        }

        @Override
        public UIElement getElementAtRow(TableViewBase view, int row) {
            return new LogRecordElement(this.td.getRecord(row), this.td.getLogModel());
        }
    }

    private class CellRendererImpl
    extends DefaultTableCellRenderer {
        private CellRendererImpl() {
        }

        @Override
        public int getHorizontalAlignment() {
            return 4;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String str;
            if (value != null) {
                Class<Comparable<RelativeTimestamp>> type = value.getClass();
                if (type.isAssignableFrom(RelativeTimestamp.class)) {
                    RelativeTimestamp ts = (RelativeTimestamp)value;
                    str = NMT_TableView.this.displayTimeModel.toString(ts);
                } else {
                    str = type.isAssignableFrom(Double.class) ? String.format("%3.1f", (Double)value) : value.toString();
                }
            } else {
                str = "";
            }
            return super.getTableCellRendererComponent(table, str, isSelected, hasFocus, row, column);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Point sp = event.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(sp, NMT_TableView.this.table);
            int rowIndex = NMT_TableView.this.table.convertRowIndexToModel(NMT_TableView.this.table.rowAtPoint(sp));
            int colIndex = NMT_TableView.this.table.convertColumnIndexToModel(NMT_TableView.this.table.columnAtPoint(sp));
            return NMT_TableView.this.td.getValueTooltipAt(rowIndex, colIndex);
        }
    }

    private class HeaderRendererImpl
    extends DefaultTableCellRenderer {
        private final TableCellRenderer rend;

        public HeaderRendererImpl(TableCellRenderer rend) {
            this.rend = rend;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent comp = (JComponent)this.rend.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setToolTipText(NMT_TableView.this.td.getColumnTooltip(table.convertColumnIndexToModel(column)));
            return comp;
        }
    }

    private final class SearchFilterTask {
        private final SearchWorker worker = new SearchWorker();

        private SearchFilterTask() {
            NMT_TableView.this.searchPanel.startProgress(500);
            this.worker.execute();
        }

        public void cancel() {
            NMT_TableView.this.searchPanel.stopProgress();
            this.worker.cancel(true);
            NMT_TableView.this.tableFilterer.reset();
        }

        private final class SearchWorker
        extends SwingWorker<Void, Void> {
            private SearchWorker() {
            }

            @Override
            protected Void doInBackground() {
                if (!this.isCancelled()) {
                    NMT_TableView.this.tableFilterer.filter();
                }
                return null;
            }

            @Override
            protected void done() {
                NMT_TableView.this.searchPanel.stopProgress();
                if (!this.isCancelled()) {
                    NMT_TableView.this.tableUpdateAction.run();
                }
            }
        }
    }
}

