/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.utils.UIUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class PopupButton
extends JToggleButton {
    public PopupButton(Icon icon) {
        this.setIcon(icon);
        this.setPreferredSize(new Dimension(54, 44));
        this.addActionListener(e -> {
            JPopupMenu popupMenu1 = this.createPopupMenu();
            popupMenu1.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    PopupButton.this.setSelected(true);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    PopupButton.this.setSelected(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    PopupButton.this.setSelected(false);
                }
            });
            popupMenu1.show(this, 0, this.getSize().height - 2);
        });
        UIUtils.autoScale(this);
    }

    protected abstract JPopupMenu createPopupMenu();

    @Override
    public final void addActionListener(ActionListener l) {
        super.addActionListener(l);
    }

    @Override
    public final void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
    }

    @Override
    public final void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics g2 = g.create();
        g2.translate(this.getWidth() - 14, this.getHeight() - 10);
        g2.setColor(this.isEnabled() ? Color.black : Color.gray);
        g2.fillPolygon(new int[]{0, 8, 4}, new int[]{0, 0, 5}, 3);
        g2.dispose();
    }

    protected static abstract class ShowAllPopupMenuItem {
        protected ShowAllPopupMenuItem() {
        }
    }

    protected static abstract class PopupMenuItem
    extends CustomJCheckBox {
        private static final Icon show = UIUtils.loadIcon("/show.png");
        private static final Icon hide = UIUtils.loadIcon("/hide.png");
        private final Paint paint;

        protected PopupMenuItem(String label, boolean isSelected, Paint paint) {
            super(label, isSelected);
            this.paint = paint;
            this.initListeners();
        }

        @Override
        public final Icon getIcon() {
            return this.isSelected() ? show : hide;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D tmp = (Graphics2D)g.create();
            Rectangle clip = g.getClip().getBounds();
            if (this.paint != null) {
                tmp.setPaint(this.paint);
                tmp.fillOval(24, (clip.height - 10) / 2, 10, 10);
            }
            tmp.dispose();
        }

        private void initListeners() {
            this.addActionListener(e -> this.performItemAction());
        }

        protected abstract void performItemAction();
    }

    protected static class CustomJCheckBox
    extends JCheckBox {
        private static final Icon empty = new ImageIcon(new BufferedImage(36, 15, 2));
        private boolean isMouseOver;

        public CustomJCheckBox(String label, boolean isSelected) {
            super(label, isSelected);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            switch (e.getID()) {
                case 504: {
                    this.isMouseOver = true;
                    break;
                }
                case 505: {
                    this.isMouseOver = false;
                    break;
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D tmp = (Graphics2D)g.create();
            Rectangle clip = g.getClip().getBounds();
            if (this.isMouseOver) {
                tmp.setColor(Color.lightGray);
                tmp.fillRect(0, 0, clip.width, clip.height);
                tmp.dispose();
            }
            super.paintComponent(g);
        }

        @Override
        public Insets getMargin() {
            return new Insets(0, 0, 0, 10);
        }

        @Override
        public Icon getIcon() {
            return empty;
        }
    }
}

