/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.ui.RangeSliderUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.BoundedRangeModel;
import javax.swing.JSlider;
import org.jfree.chart.JFreeChart;

public final class RangeSlider
extends JSlider {
    private final JFreeChart chart;

    public RangeSlider(BoundedRangeModel model) {
        this(null, model);
    }

    public RangeSlider(JFreeChart chart, BoundedRangeModel model) {
        super(0);
        this.setModel(model);
        this.chart = chart;
    }

    protected boolean isBackgroundChartAvailable() {
        return Objects.nonNull(this.chart);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension def = super.getPreferredSize();
        return new Dimension(def.width, this.isBackgroundChartAvailable() ? def.height * 3 : def.height);
    }

    @Override
    public void updateUI() {
        this.setUI(new RangeSliderUI(this));
        this.updateLabelUIs();
    }

    @Override
    public void setValue(int value) {
        int oldValue = this.getValue();
        if (oldValue == value) {
            return;
        }
        int oldExtent = this.getExtent();
        int newValue = Math.min(Math.max(this.getMinimum(), value), oldValue + oldExtent);
        int newExtent = Math.max(10, oldExtent + oldValue - newValue);
        this.getModel().setRangeProperties(newValue, newExtent, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
    }

    public void setUpperValue(int value) {
        int lowerValue = this.getValue();
        int newExtent = Math.min(Math.max(0, value - lowerValue), this.getMaximum() - lowerValue);
        if (this.getExtent() != newExtent) {
            super.setExtent(newExtent);
        }
    }

    @Override
    public void setExtent(int extent) {
        super.setExtent(Math.max(10, extent));
    }

    public int getUpperValue() {
        return this.getValue() + this.getExtent();
    }

    public BufferedImage createBackgroundImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, width, height);
        this.chart.getPlot().draw(g2, new Rectangle2D.Double(8.0, 0.0, width - 16, height), null, null, null);
        g2.setColor(Color.gray);
        g2.drawLine(0, 0, width, 0);
        g2.dispose();
        return image;
    }
}

