/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import java.util.Stack;

public class ViewsNavigationHistory {
    private Stack<Integer> backStack = new Stack();
    private Stack<Integer> forwardStack = new Stack();
    private static final ViewsNavigationHistory instance = new ViewsNavigationHistory();

    public static ViewsNavigationHistory getInstance() {
        return instance;
    }

    private ViewsNavigationHistory() {
    }

    public void visit(int viewID) {
        if (this.backStack.isEmpty() || this.backStack.peek() != viewID) {
            this.backStack.push(viewID);
        }
    }

    public void goBack() {
        if (this.forwardStack.isEmpty() || !this.forwardStack.peek().equals(this.backStack.peek())) {
            this.forwardStack.push(this.backStack.peek());
        }
        this.backStack.pop();
    }

    public void goForward() {
        if (this.forwardStack.isEmpty() || !this.backStack.peek().equals(this.forwardStack.peek())) {
            this.backStack.push(this.forwardStack.peek());
        }
        this.forwardStack.pop();
    }

    public int getBackStackSize() {
        return this.backStack.size();
    }

    public int getForwardStackSize() {
        return this.forwardStack.size();
    }

    public int getPreviousViewID() {
        return this.backStack.peek();
    }

    public int getNextViewID() {
        return this.forwardStack.peek();
    }

    public void clearHistory() {
        this.backStack.clear();
        this.forwardStack.clear();
    }
}

