/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils;

import com.azul.log.gui.utils.UIUtils;
import com.azul.log.gui.utils.jfreechart.JFreeChartSupport;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.AWTEventListener;
import java.awt.event.ContainerEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class FontSizeAdjuster
implements AWTEventListener {
    private static final String PREFERRED_SIZE = "preferredSize";
    private final float fontSize;
    private final float scale;
    private final boolean scaleButtons;

    public FontSizeAdjuster(float fontSize, float scale) {
        this.fontSize = fontSize;
        this.scale = scale;
        this.scaleButtons = (double)Math.abs(scale - 1.0f) > 0.01;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        ContainerEvent containerEvent;
        if (event instanceof ContainerEvent && (containerEvent = (ContainerEvent)event).getID() == 300) {
            this.adjustFontSize(containerEvent.getChild());
            if (this.scaleButtons) {
                this.adjustButtons(containerEvent.getChild());
            }
        }
    }

    private void adjustFontSize(Component c) {
        if (!JFreeChartSupport.adjustFontSize(c, this.fontSize)) {
            Font orig = c.getFont();
            if (orig != null) {
                try {
                    c.setFont(orig.deriveFont(this.fontSize * this.scale));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (c instanceof Container) {
                for (Component comp : ((Container)c).getComponents()) {
                    this.adjustFontSize(comp);
                }
            }
        }
    }

    private void adjustButtons(Component comp) {
        if (!(comp instanceof JComponent)) {
            return;
        }
        final JComponent component = (JComponent)comp;
        if (UIUtils.isAutoScale(component)) {
            PropertyChangeListener sizeChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Dimension ps = component.getPreferredSize();
                    ps.height = (int)((float)ps.height * FontSizeAdjuster.this.scale);
                    ps.width = (int)((float)ps.width * FontSizeAdjuster.this.scale);
                    component.removePropertyChangeListener(FontSizeAdjuster.PREFERRED_SIZE, this);
                    component.setPreferredSize(ps);
                    component.addPropertyChangeListener(FontSizeAdjuster.PREFERRED_SIZE, this);
                }
            };
            component.addPropertyChangeListener(PREFERRED_SIZE, sizeChangeListener);
            sizeChangeListener.propertyChange(null);
            IconChangeListener iconChangeListener = null;
            if (component instanceof AbstractButton) {
                iconChangeListener = new IconChangeListener(component){

                    @Override
                    protected void scaleComponentIcon() {
                        ((AbstractButton)component).setIcon(this.scaleIcon(((AbstractButton)component).getIcon()));
                    }
                };
            } else if (component instanceof JLabel) {
                iconChangeListener = new IconChangeListener(component){

                    @Override
                    protected void scaleComponentIcon() {
                        ((JLabel)component).setIcon(this.scaleIcon(((JLabel)component).getIcon()));
                    }
                };
            }
            if (iconChangeListener != null) {
                component.addPropertyChangeListener("icon", iconChangeListener);
                iconChangeListener.propertyChange(null);
            }
        }
    }

    private abstract class IconChangeListener
    implements PropertyChangeListener {
        private final JComponent comp;

        protected IconChangeListener(JComponent comp) {
            this.comp = comp;
        }

        @Override
        public final void propertyChange(PropertyChangeEvent evt) {
            this.comp.removePropertyChangeListener("icon", this);
            this.scaleComponentIcon();
            this.comp.addPropertyChangeListener("icon", this);
        }

        protected abstract void scaleComponentIcon();

        protected ImageIcon scaleIcon(Icon icon) {
            return icon instanceof ImageIcon ? new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance((int)((float)icon.getIconWidth() * FontSizeAdjuster.this.scale), (int)((float)icon.getIconHeight() * FontSizeAdjuster.this.scale), 4)) : null;
        }
    }
}

