/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.spi.ChartElementShapeProviderFactory;
import com.azul.log.gui.graphs.spi.GraphTooltipProvider;
import com.azul.log.gui.marks.Mark;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.ScratchpadModel;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.model.spi.PhasesInfoProvider;
import com.azul.log.gui.ui.Markline;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.gui.utils.jfreechart.ChartShapeProviderFactory;
import com.azul.log.gui.utils.jfreechart.JFreeChartRecordElement;
import com.azul.log.gui.utils.jfreechart.PlotEx;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.utils.TextUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.RendererUtils;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.util.ShapeUtils;
import org.jfree.data.general.DatasetUtils;
import org.jfree.data.xy.XYDataset;
import org.openide.util.Lookup;

public final class ChartExRenderer
extends XYLineAndShapeRenderer {
    private static final Shape selectionShape = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
    private static final Stroke dashedStroke = new BasicStroke(0.3f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
    private static final Color[] phaseColors = new Color[]{Color.decode("#FFC0CB"), Color.decode("#ADFF2F"), Color.decode("#E6E6FA"), Color.decode("#00FFFF"), Color.decode("#FFA07A"), Color.decode("#FFD700"), Color.decode("#FFA500")};
    private static final int PATH_LIMIT = 2500;
    private final GraphDefinition graphDefinition;
    private final ChartRendererMode mode;
    private final MarksModel.MarksCategoryModel logMarklinesVisibilityModel;
    private final MarksModel marksModel;
    private final ArrayList<ItemEntityInfo> entityInfoList = new ArrayList(2500);
    private boolean notificationsEnabled = true;
    private ChartElementShapeProviderFactory.ChartElementShapeProvider chartElementShapeProvider;

    ChartExRenderer(GraphDefinition graphDefinition, ChartRendererMode mode) {
        this.graphDefinition = graphDefinition;
        this.mode = mode;
        this.marksModel = Context.lookup(MarksModel.class);
        this.logMarklinesVisibilityModel = this.marksModel.getCategoriesModel();
        this.setDrawSeriesLineAsPath(true);
    }

    @Override
    public void notifyListeners(RendererChangeEvent event) {
        if (this.notificationsEnabled) {
            super.notifyListeners(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeriesPaint(int idx, Paint paint) {
        boolean ne = this.notificationsEnabled;
        this.notificationsEnabled = false;
        try {
            super.setSeriesPaint(idx, paint);
            this.setSeriesLinesVisible(idx, true);
            if (this.mode == ChartRendererMode.SLIDER || this.mode == ChartRendererMode.SLIDER_SCRATCHPAD) {
                this.setSeriesStroke(idx, new BasicStroke(1.0f));
                this.setSeriesShapesVisible(idx, false);
            } else {
                this.setSeriesStroke(idx, new BasicStroke(1.2f));
                this.setSeriesShapesVisible(idx, true);
            }
        }
        finally {
            this.notificationsEnabled = ne;
        }
    }

    private void drawSelectionPoint(Graphics2D g2, double x, double y) {
        Shape shape;
        Rectangle cb = g2.getClipBounds();
        if (cb.intersects((shape = ShapeUtils.createTranslatedShape(selectionShape, x, y)).getBounds())) {
            g2.setPaint(Color.black);
            g2.fill(shape);
        }
    }

    private double timestampToXCoord(RelativeTimestamp timestamp, Rectangle2D dataArea, ValueAxis domainAxis) {
        double ns = timestamp.getInUnits(TimeUnit.NANOSECONDS);
        RectangleEdge edge = this.getPlot().getDomainAxisEdge();
        return domainAxis.valueToJava2D(ns, dataArea, edge);
    }

    private void drawPhases(Graphics2D g2, Rectangle2D dataArea, ValueAxis domainAxis, PhasesInfoProvider infoProvider, PlotRenderingInfo info) {
        Rectangle cb = g2.getClipBounds();
        int cidx = 0;
        LogRecord.PhaseInfoList phases = infoProvider.getPhases();
        EntityCollection entityCollection = info.getOwner().getEntityCollection();
        String units = " " + TextUtils.getTimeUnitSuffix(phases.getTimeUnits());
        StringBuilder sb = new StringBuilder();
        sb.append("<html><b>").append(phases.getDescription()).append("</b><hr>");
        sb.append("<table cellpadding='0' border='0' style='white-space:nowrap'>");
        int init_len = sb.length();
        NumberFormat nf = UIUtils.getNumberFormat();
        nf.setMinimumFractionDigits(3);
        nf.setMaximumFractionDigits(3);
        for (LogRecord.PhaseInfo curr_phase : phases) {
            double phase_start_x = this.timestampToXCoord(curr_phase.start, dataArea, domainAxis);
            double phase_end_x = this.timestampToXCoord(curr_phase.end, dataArea, domainAxis);
            if (phase_end_x - phase_start_x >= 1.0) {
                sb.setLength(init_len);
                phases.forEach(p -> {
                    double duration = RelativeTimestamp.delta(p.end, p.start, phases.getTimeUnits());
                    boolean curr = p.equals(curr_phase);
                    String hls = curr ? "<font color='#774422'>" : "";
                    String hle = curr ? "</font>" : "";
                    String marker = curr ? "&#8226;" : "";
                    sb.append("<tr>");
                    sb.append("<td>").append(marker).append("</td>");
                    sb.append("<td align='left'>");
                    sb.append(hls).append(p.name).append(hle);
                    sb.append("</td>");
                    sb.append("<td align='right' style='padding: 0 0 0 10'>");
                    sb.append(hls).append(nf.format(duration)).append(units).append(hle);
                    sb.append("</td>");
                    sb.append("<td>").append(marker).append("</td>");
                    sb.append("</tr>");
                });
                sb.append("</table></html>");
                String tooltip = sb.toString();
                Graphics2D tmp = (Graphics2D)g2.create();
                tmp.translate(phase_start_x, (double)cb.y);
                tmp.setComposite(AlphaComposite.getInstance(3, 0.3f));
                tmp.setPaint(phaseColors[cidx % phaseColors.length]);
                Rectangle2D.Double fill = new Rectangle2D.Double(0.0, 0.0, phase_end_x - phase_start_x, cb.height);
                tmp.fill(fill);
                tmp.dispose();
                Shape entityShape = ShapeUtils.createTranslatedShape(fill, phase_start_x, cb.y);
                ChartEntity entity = new ChartEntity(entityShape, tooltip);
                entityCollection.add(entity);
            }
            ++cidx;
        }
    }

    private void drawSelectionLine(Graphics2D g2, Rectangle2D dataArea, ValueAxis domainAxis, UIElement elem, PlotRenderingInfo info) {
        Rectangle cb = g2.getClipBounds();
        Graphics2D tmp = (Graphics2D)g2.create();
        double x = this.timestampToXCoord(elem.getTimestamp(), dataArea, domainAxis);
        tmp.translate(x, (double)cb.y);
        tmp.setPaint(Color.red);
        tmp.setStroke(dashedStroke);
        tmp.drawLine(0, 0, 0, cb.height);
        tmp.dispose();
        if (Config.isActive("DRAW_EVENT_PHASES") && elem instanceof PhasesInfoProvider) {
            this.drawPhases(g2, dataArea, domainAxis, (PhasesInfoProvider)((Object)elem), info);
        }
    }

    private Shape getShape(int series, int item) {
        LogRecord record = this.graphDefinition.getGraphData().get(series).getData().get(item);
        return this.chartElementShapeProvider.getItemShape(record);
    }

    void drawAllSeries(Graphics2D g2, Rectangle2D dataArea, PlotEx plot, XYDataset dataset, ValueAxis xAxis, ValueAxis yAxis, PlotRenderingInfo info) {
        int seriesCount = dataset.getSeriesCount();
        int selectedSeries = -1;
        UIElement selectedElement = UIElementSelectionModel.getInstance().getSelectedElement();
        if (selectedElement instanceof JFreeChartRecordElement) {
            JFreeChartRecordElement elem = (JFreeChartRecordElement)selectedElement;
            if (elem.graphDefinition == this.graphDefinition) {
                selectedSeries = elem.seriesIndex;
            }
        }
        this.chartElementShapeProvider = ChartShapeProviderFactory.getProviderFor(this.graphDefinition);
        for (int series = seriesCount - 1; series >= 0; --series) {
            if (series == selectedSeries) continue;
            this.drawSingleSeries(g2, dataArea, plot, dataset, xAxis, yAxis, series, info);
        }
        if (selectedSeries != -1) {
            this.drawSingleSeries(g2, dataArea, plot, dataset, xAxis, yAxis, selectedSeries, info);
        }
    }

    private void drawSingleSeries(Graphics2D g2, Rectangle2D dataArea, PlotEx plot, XYDataset dataset, ValueAxis xAxis, ValueAxis yAxis, int series, PlotRenderingInfo info) {
        if (!this.isSeriesVisible(series)) {
            return;
        }
        if (DatasetUtils.isEmptyOrNull(dataset)) {
            return;
        }
        int pathCapacity = 2500;
        double prev_x = -1.0;
        double prev_y = -1.0;
        double prev_min_y = 3.4028234663852886E38;
        double prev_max_y = 1.4E-45f;
        boolean multiple_points_on_same_x = false;
        boolean connectPoint = false;
        this.entityInfoList.clear();
        int[] itemBounds = RendererUtils.findLiveItems(dataset, series, xAxis.getLowerBound(), xAxis.getUpperBound());
        int firstItem = Math.max(itemBounds[0] - 1, 0);
        int lastItem = Math.min(itemBounds[1] + 1, dataset.getItemCount(series) - 1);
        GeneralPath seriesPath = new GeneralPath(1, 2500);
        RectangleEdge xAxisEdge = plot.getDomainAxisEdge();
        RectangleEdge yAxisEdge = plot.getRangeAxisEdge();
        EntityCollection entities = null;
        if (info != null) {
            double y;
            double x_val = dataset.getXValue(series, firstItem);
            double y_val = dataset.getYValue(series, firstItem);
            double x = xAxis.valueToJava2D(x_val, dataArea, xAxisEdge);
            if (dataArea.contains(x, y = yAxis.valueToJava2D(y_val, dataArea, yAxisEdge))) {
                this.entityInfoList.add(new ItemEntityInfo(firstItem, x, y));
            }
            entities = info.getOwner().getEntityCollection();
        }
        g2.setStroke(this.getItemStroke(series, 0));
        g2.setPaint(this.getItemPaint(series, 0));
        for (int item = firstItem; item <= lastItem; ++item) {
            double x_val = dataset.getXValue(series, item);
            double y_val = dataset.getYValue(series, item);
            double x = xAxis.valueToJava2D(x_val, dataArea, xAxisEdge);
            double y = yAxis.valueToJava2D(y_val, dataArea, yAxisEdge);
            if (Double.isNaN(x) || Double.isNaN(y)) {
                connectPoint = false;
                continue;
            }
            if (connectPoint) {
                if ((int)prev_x != (int)x) {
                    if (multiple_points_on_same_x) {
                        seriesPath.moveTo(prev_x, prev_min_y);
                        seriesPath.lineTo(prev_x, prev_max_y);
                        seriesPath.moveTo(prev_x, prev_y);
                    }
                    seriesPath.lineTo(x, y);
                    if (info != null && dataArea.contains(x, y)) {
                        this.entityInfoList.add(new ItemEntityInfo(item, x, y));
                    }
                    prev_x = x;
                    prev_max_y = prev_min_y = y;
                    prev_y = prev_min_y;
                    multiple_points_on_same_x = false;
                } else {
                    if (Math.abs(prev_y - y) > 6.0 && dataArea.contains(x, y)) {
                        this.entityInfoList.add(new ItemEntityInfo(item, x, y));
                    }
                    prev_y = y;
                    prev_max_y = Math.max(prev_max_y, y);
                    prev_min_y = Math.min(prev_min_y, y);
                    multiple_points_on_same_x = true;
                }
            } else {
                seriesPath.moveTo(x, y);
            }
            connectPoint = true;
            if (--pathCapacity != 0) continue;
            pathCapacity = 2500;
            g2.draw(seriesPath);
            this.createAndDrawEntities(dataset, series, g2, entities);
            seriesPath.reset();
            this.entityInfoList.clear();
            seriesPath.moveTo(x, y);
        }
        if (multiple_points_on_same_x) {
            seriesPath.moveTo(prev_x, prev_min_y);
            seriesPath.lineTo(prev_x, prev_max_y);
        }
        g2.draw(seriesPath);
        this.createAndDrawEntities(dataset, series, g2, entities);
        seriesPath.reset();
        this.entityInfoList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndDrawEntities(XYDataset dataset, int series, Graphics2D graphics, EntityCollection entities) {
        if (entities == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)graphics.create();
        try {
            g2.setStroke(DEFAULT_OUTLINE_STROKE);
            g2.setPaint(this.getItemPaint(series, 0));
            this.entityInfoList.forEach(info -> {
                int item = info.item;
                Shape shape = this.getShape(series, item);
                shape = ShapeUtils.createTranslatedShape(shape, info.x, info.y);
                g2.fill(shape);
                entities.add(new XYItemEntityEx(shape, dataset, series, item));
            });
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public void drawAnnotations(Graphics2D g2, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, Layer layer, PlotRenderingInfo info) {
        if (this.mode == ChartRendererMode.SLIDER || this.mode == ChartRendererMode.SLIDER_SCRATCHPAD || !this.graphDefinition.hasData() || info == null) {
            return;
        }
        UIElement selectedElement = UIElementSelectionModel.getInstance().getSelectedElement();
        EntityCollection entities = info.getOwner().getEntityCollection();
        if (selectedElement != null && !(selectedElement instanceof Mark)) {
            switch (layer) {
                case BACKGROUND: {
                    this.drawSelectionLine(g2, dataArea, domainAxis, selectedElement, info);
                    break;
                }
                case FOREGROUND: {
                    if (!(selectedElement instanceof JFreeChartRecordElement)) break;
                    JFreeChartRecordElement elem = (JFreeChartRecordElement)selectedElement;
                    if (elem.graphDefinition != this.graphDefinition || !this.isSeriesVisible(elem.seriesIndex)) break;
                    int datasetIndex = 0;
                    if (this.mode == ChartRendererMode.MAIN_SCRATCHPAD && ScratchpadModel.getModel().isDisplayed(this.graphDefinition)) {
                        datasetIndex = ScratchpadModel.getModel().getDatasetIndex(elem.graphDefinition);
                    }
                    double val = this.getPlot().getDataset(datasetIndex).getYValue(elem.seriesIndex, elem.itemIndex);
                    double selection_x = this.timestampToXCoord(selectedElement.getTimestamp(), dataArea, domainAxis);
                    double selection_y = rangeAxis.valueToJava2D(val, dataArea, this.getPlot().getRangeAxisEdge());
                    this.drawSelectionPoint(g2, selection_x, selection_y);
                }
            }
        }
        if (layer == Layer.BACKGROUND) {
            this.drawMarklines(g2, dataArea, domainAxis, this.marksModel.getMarks(), entities);
        }
        super.drawAnnotations(g2, dataArea, domainAxis, rangeAxis, layer, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMarklines(Graphics2D g2, Rectangle2D dataArea, ValueAxis domainAxis, Iterable<? extends Mark> marks, EntityCollection entities) {
        double prev_x = -1.0;
        Graphics2D g = (Graphics2D)g2.create();
        Rectangle cb = g.getClipBounds();
        RectangleEdge edge = this.getPlot().getDomainAxisEdge();
        FontMetrics fm = g.getFontMetrics();
        ArrayList<Rectangle> flagBoundsList = new ArrayList<Rectangle>();
        Set<String> visibleCategories = this.logMarklinesVisibilityModel.getVisibleCategories();
        try {
            for (Mark mark : marks) {
                Shape s;
                if (!visibleCategories.contains(mark.getCategory())) continue;
                double ns = mark.getTimestamp().getInUnits(TimeUnit.NANOSECONDS);
                double x = domainAxis.valueToJava2D(ns, dataArea, edge);
                int y_shift = 0;
                if (prev_x == x || x < dataArea.getMinX()) continue;
                prev_x = x;
                g.translate(x, (double)cb.y);
                if ((this.mode == ChartRendererMode.MAIN || this.mode == ChartRendererMode.MAIN_SCRATCHPAD) && Markline.isLabelVisible(mark)) {
                    Rectangle2D.Double flagBounds;
                    boolean hit;
                    String text = mark.getLabel();
                    g.setFont(Markline.AttributesProvider.getLabelFont(mark));
                    Rectangle r = fm.getStringBounds(text, g).getBounds();
                    y_shift = 0;
                    block4: do {
                        hit = false;
                        flagBounds = new Rectangle2D.Double(x, y_shift, r.width + 12, r.height + 2);
                        for (Rectangle fb : flagBoundsList) {
                            if (!fb.intersects(flagBounds)) continue;
                            y_shift += r.height + 3;
                            hit = true;
                            continue block4;
                        }
                    } while (hit);
                    s = new Polygon(new int[]{0, 0, 1, 1, r.width + 12, r.width + 7, r.width + 12, 0}, new int[]{0, cb.height, cb.height, r.height + 2, r.height + 2, r.height / 2 + 1, 0, 0}, 8);
                    g.translate(0, y_shift);
                    flagBoundsList.add(flagBounds.getBounds());
                    g.setPaint(Markline.AttributesProvider.getLineColor(mark));
                    g.fill(s);
                    g.setPaint(Markline.AttributesProvider.getLabelColor(mark));
                    g.drawString(text, 4, r.height - 2);
                    if (mark.isSelected()) {
                        g.setPaint(Color.black);
                        g.draw(s);
                    }
                    s = new Polygon(new int[]{-3, -3, 6, 6, r.width + 12, r.width + 7, r.width + 12, -3}, new int[]{0, cb.height, cb.height, r.height + 2, r.height + 2, r.height / 2 + 1, 0, 0}, 8);
                } else {
                    g.setPaint(Markline.AttributesProvider.getLineColor(mark));
                    s = new Rectangle2D.Double(0.0, 0.0, 1.0, cb.height);
                    g.fill(s);
                    if (mark.isSelected()) {
                        g.setPaint(Color.black);
                        g.draw(s);
                    }
                    s = new Rectangle2D.Double(-3.0, 0.0, 6.0, cb.height);
                }
                g.translate(-x, (double)(-cb.y - y_shift));
                AffineTransform tr = AffineTransform.getTranslateInstance(x, cb.y + y_shift);
                Shape shape = tr.createTransformedShape(s);
                entities.add(new Markline(shape, mark));
            }
        }
        finally {
            g.dispose();
        }
    }

    @Override
    public Shape getLegendShape(int series) {
        return selectionShape;
    }

    @Override
    protected void addEntity(EntityCollection entities, Shape hotspot, XYDataset dataset, int series, int item, double entityX, double entityY) {
        if (this.mode != ChartRendererMode.MAIN_SCRATCHPAD) {
            throw new InternalError("Should not be called");
        }
        super.addEntity(entities, hotspot, dataset, series, item, entityX, entityY);
    }

    String getXLabel() {
        return this.graphDefinition.getXLabel();
    }

    String getYLabel() {
        return this.graphDefinition.getYLabel();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChartExRenderer)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ChartExRenderer that = (ChartExRenderer)obj;
        return Objects.equals(this.graphDefinition, that.graphDefinition) && Objects.equals((Object)this.mode, (Object)that.mode);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 19 * hash + Objects.hashCode(this.graphDefinition);
        hash = 19 * hash + Objects.hashCode((Object)this.mode);
        return hash;
    }

    private class XYItemEntityEx
    extends XYItemEntity {
        private final GraphTooltipProvider tooltipProvider;

        public XYItemEntityEx(Shape area, XYDataset dataset, int series, int item) {
            super(area, dataset, series, item, null, null);
            this.tooltipProvider = Lookup.getDefault().lookup(GraphTooltipProvider.class);
        }

        @Override
        public String getToolTipText() {
            if (this.tooltipProvider == null) {
                return null;
            }
            NumberAxis rangeAxis = (NumberAxis)ChartExRenderer.this.getPlot().getRangeAxis();
            double size = rangeAxis.getTickUnit().getSize();
            int valueFractionDigits = -((int)Math.floor(Math.log10(size)));
            return this.tooltipProvider.getTooltip(ChartExRenderer.this.graphDefinition, this.getSeriesIndex(), this.getItem(), valueFractionDigits);
        }
    }

    private static class ItemEntityInfo {
        private final int item;
        private final double x;
        private final double y;

        ItemEntityInfo(int idx, double x, double y) {
            this.item = idx;
            this.x = x;
            this.y = y;
        }
    }

    public static enum ChartRendererMode {
        MAIN,
        PREVIEW,
        SLIDER,
        MAIN_SCRATCHPAD,
        SLIDER_SCRATCHPAD;

    }
}

