/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.model.FavoriteGraphsModel;
import com.azul.log.gui.utils.UIUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

final class FavoriteToggleButton
extends JToggleButton {
    private final ImageIcon activeIcon = UIUtils.loadIcon("/buttons/star-active.png");
    private final ImageIcon inactiveIcon = UIUtils.loadIcon("/buttons/star-inactive.png");

    public FavoriteToggleButton(final int chartId) {
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FavoriteToggleButton.this.isSelected()) {
                    FavoriteGraphsModel.getModel().add(chartId);
                    FavoriteToggleButton.this.setIcon(FavoriteToggleButton.this.activeIcon);
                } else {
                    FavoriteGraphsModel.getModel().remove(chartId);
                    FavoriteToggleButton.this.setIcon(FavoriteToggleButton.this.inactiveIcon);
                }
            }
        });
        this.setSelected(FavoriteGraphsModel.getModel().contains(chartId));
        this.setIcon(this.isSelected() ? this.activeIcon : this.inactiveIcon);
        this.setPreferredSize(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
        this.putClientProperty("autoresize", Boolean.TRUE);
    }
}

