/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.ScratchpadModel;
import com.azul.log.gui.model.ScratchpadsSelectionModel;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.ui.ScratchpadPanel;
import com.azul.log.gui.utils.jfreechart.BaseChartPanelEx;
import com.azul.log.gui.utils.jfreechart.JFreeChartRecordElement;
import com.azul.log.gui.utils.jfreechart.NumberAxisEx;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.XYItemEntity;
import org.openide.util.Lookup;

public final class ScratchpadChartPanelEx
extends BaseChartPanelEx {
    private final Lookup.Result<DisplayTimeModel> displayTimeModelResult;
    private final Lookup.Result<MarksModel> marksModelResult;
    private final Lookup.Result<MarksModel.MarksCategoryModel> marksCategoryModelResult;
    private final ChangeListener displayTimeModelListener = new DisplayTimeModelListener();
    private final ChangeListener chartChangeListener;

    public ScratchpadChartPanelEx(JFreeChart chart) {
        super(chart);
        this.addChartMouseListener(new ScratchpadMouseListenerImpl());
        UIElementSelectionModel.getInstance().addChangeListener(new SelectionListener());
        this.chartChangeListener = new BaseChartPanelEx.ChangeListenerImpl(chart);
        this.displayTimeModelResult = Context.lookupResult(DisplayTimeModel.class);
        this.displayTimeModelResult.addLookupListener(e -> {
            DisplayTimeModel displayTimeModel = Context.lookup(DisplayTimeModel.class);
            if (displayTimeModel == null) {
                return;
            }
            displayTimeModel.removeChangeListener(this.displayTimeModelListener);
            displayTimeModel.addChangeListener(this.displayTimeModelListener);
        });
        this.marksModelResult = Context.lookupResult(MarksModel.class);
        this.marksModelResult.addLookupListener(e -> {
            MarksModel marksModel = Context.lookup(MarksModel.class);
            if (marksModel == null) {
                return;
            }
            marksModel.removeChangeListener(this.chartChangeListener);
            marksModel.addChangeListener(this.chartChangeListener);
        });
        this.marksCategoryModelResult = Context.lookupResult(MarksModel.MarksCategoryModel.class);
        this.marksCategoryModelResult.addLookupListener(e -> {
            MarksModel.MarksCategoryModel marksCategoryModel = Context.lookup(MarksModel.MarksCategoryModel.class);
            if (marksCategoryModel == null) {
                return;
            }
            marksCategoryModel.removeChangeListener(this.chartChangeListener);
            marksCategoryModel.addChangeListener(this.chartChangeListener);
        });
        this.setLayout(null);
    }

    @Override
    protected boolean isMainPanel() {
        return true;
    }

    @Override
    protected GraphDefinition getGraphDefinition() {
        throw new InternalError();
    }

    @Override
    protected JFreeChartRecordElement createChartRecordElement(XYItemEntity item) {
        GraphDefinition gd = ScratchpadModel.getModel().getGraphDefinitionForDataset(this.getChart().getXYPlot(), item.getDataset());
        int seriesIndex = item.getSeriesIndex();
        int itemIndex = item.getItem();
        int itemCount = item.getDataset().getItemCount(seriesIndex);
        return JFreeChartRecordElement.create(gd, seriesIndex, itemIndex, itemCount);
    }

    @Override
    protected String getSaveAsFileName() {
        return "Scratchpad";
    }

    public JMenu createScratchpadSelectionMenu(JMenu load, JMenu remove, Action save) {
        JMenu scratchpadSelectionMenu = new JMenu("Scratchpads");
        scratchpadSelectionMenu.add(save);
        scratchpadSelectionMenu.add(load);
        scratchpadSelectionMenu.addSeparator();
        scratchpadSelectionMenu.add(remove);
        return scratchpadSelectionMenu;
    }

    public void setUpPopupMenu(final ScratchpadPanel scratchpadPanel, Action clearAction) {
        BaseChartPanelEx.LabelsVisibilitySupport labelsVisibilitySupport = new BaseChartPanelEx.LabelsVisibilitySupport(this);
        final ScratchpadsSelectionModel scratchpadsSelectionModel = ScratchpadsSelectionModel.getModel();
        JMenu loadScratchpad = new JMenu("Load Scratchpad");
        JMenu removeScratchpad = new JMenu("Remove Scratchpad");
        AbstractAction saveScratchpadMenuItem = new AbstractAction("Save Scratchpad"){

            @Override
            public void actionPerformed(ActionEvent e) {
                scratchpadsSelectionModel.saveScratchpad(scratchpadPanel);
            }
        };
        scratchpadsSelectionModel.initMenus(scratchpadPanel, loadScratchpad, removeScratchpad);
        JMenu scratchpadSelectionMenu = this.createScratchpadSelectionMenu(loadScratchpad, removeScratchpad, saveScratchpadMenuItem);
        JPopupMenu menu = this.getPopupMenu();
        menu.addSeparator();
        menu.add(labelsVisibilitySupport.getMenuPresenter());
        menu.addSeparator();
        menu.add(scratchpadSelectionMenu);
        menu.add(clearAction);
    }

    private class SelectionListener
    implements ChangeListener {
        private SelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ScratchpadChartPanelEx.this.getChart().fireChartChanged();
        }
    }

    protected class ScratchpadMouseListenerImpl
    extends BaseChartPanelEx.ChartMouseListenerImpl {
        protected ScratchpadMouseListenerImpl() {
        }

        @Override
        public void chartMouseClicked(ChartMouseEvent cme) {
            super.chartMouseClickedEx(cme);
        }
    }

    private class DisplayTimeModelListener
    implements ChangeListener {
        private DisplayTimeModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            NumberAxisEx axis = new NumberAxisEx();
            axis.setVisible(true);
            ScratchpadChartPanelEx.this.getChart().getXYPlot().setDomainAxis(axis);
        }
    }
}

