/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.model.api;

import com.azul.log.model.api.FieldDescription;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.spi.annotations.LogLineField;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import com.azul.log.parser.spi.annotations.LogRecordField;
import com.azul.log.parser.support.FieldSetterSupport;
import com.azul.log.parser.support.LogDataFieldsAccessor;
import com.azul.log.parser.support.TimeAdjustmentSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.naming.OperationNotSupportedException;

public abstract class LogRecord {
    private static final Map<Class<? extends LogRecord>, DataClassData> dataMap = new HashMap<Class<? extends LogRecord>, DataClassData>();
    private static final Map<Class<? extends LogRecord>, List<Field>> fields = new HashMap<Class<? extends LogRecord>, List<Field>>();
    private RelativeTimestamp logRelativeTimestamp;
    private int logLineNumber;
    private long bitmap1 = 0L;
    private long bitmap2 = 0L;
    private static final ConcurrentHashMap<Field, LogUnits> unitsCache;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(":");
        for (Field field : this.getClass().getFields()) {
            try {
                sb.append(" ").append(field.getName()).append(": ");
                sb.append(this.isFieldDefined(field) ? field.get(this) : "-");
                sb.append(",");
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(LogRecord.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    public List<Field> getAllFields() {
        return fields.computeIfAbsent(this.getClass(), LogRecord::getFieldsImpl);
    }

    protected String getFieldShortDescription(Field field) {
        return this.getFieldName(field);
    }

    protected List<String> getFieldNotes(Field field) {
        return Collections.emptyList();
    }

    protected String getFieldName(Field field) {
        return field.getName();
    }

    protected String getFieldSpec(Field field) {
        return null;
    }

    protected Set<Field> getDerivedFromFields(Field field) {
        return Collections.emptySet();
    }

    public static LogUnits getFieldUnits(Field field) {
        return unitsCache.computeIfAbsent(field, id -> {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                try {
                    Method method = annotation.annotationType().getMethod("defaultUnits", new Class[0]);
                    Object units = method.invoke((Object)annotation, new Object[0]);
                    if (!(units instanceof LogUnits)) continue;
                    return (LogUnits)((Object)((Object)units));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            return LogUnits.UNSPECIFIED;
        });
    }

    public final FieldDescription getFieldDescription(final Field field) {
        return new FieldDescription(){

            @Override
            public String shortDescription() {
                return LogRecord.this.getFieldShortDescription(field);
            }

            @Override
            public List<String> notes() {
                return LogRecord.this.getFieldNotes(field);
            }

            @Override
            public String name() {
                return LogRecord.this.getFieldName(field);
            }

            @Override
            public LogUnits units() {
                return LogRecord.getFieldUnits(field);
            }

            @Override
            public Set<Field> derivedFromFields() {
                return LogRecord.this.getDerivedFromFields(field);
            }

            @Override
            public String fieldSpec() {
                return LogRecord.this.getFieldSpec(field);
            }
        };
    }

    private static List<Field> getFieldsImpl(Class<? extends LogRecord> klass) {
        return Arrays.stream(klass.getDeclaredFields()).filter(f -> Modifier.isPublic(f.getModifiers()) && !Modifier.isStatic(f.getModifiers())).collect(Collectors.toList());
    }

    private static DataClassData init(Class<? extends LogRecord> k) {
        if (k == null) {
            return null;
        }
        DataClassData classData = new DataClassData();
        int idx = 0;
        for (Field field : k.getFields()) {
            boolean has_annotation;
            boolean bl = has_annotation = field.getAnnotation(LogRecordField.class) != null || Arrays.stream(field.getAnnotations()).map(Annotation::annotationType).map(t -> t.getAnnotation(LogRecordField.class)).anyMatch(Objects::nonNull);
            if (!has_annotation) continue;
            classData.put(field, new FieldInfo(k, field, idx++));
        }
        return classData;
    }

    private static DataClassData getDataClassData(Class<? extends LogRecord> klass) {
        return dataMap.computeIfAbsent(klass, LogRecord::init);
    }

    protected static Field getField(Class<? extends LogRecord> k, String name) {
        try {
            return k.getField(name);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(LogRecord.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public final int getLogLineNumber() {
        return this.logLineNumber;
    }

    protected PhaseInfoList getEventPhasesImpl() {
        return UnmodifiablePhaseInfoList.EMPTY;
    }

    public final PhaseInfoList getEventPhases() {
        return new UnmodifiablePhaseInfoList(this.getEventPhasesImpl());
    }

    public final RelativeTimestamp getLogRelativeTimestamp() {
        return TimeAdjustmentSupport.adjust(this.logRelativeTimestamp);
    }

    public final double getLogRelativeTimestamp(TimeUnit timeUnit) {
        return this.getLogRelativeTimestamp().getInUnits(timeUnit);
    }

    public final RelativeTimestamp getEventRelativeTimestamp() {
        return Optional.ofNullable(this.getEventRawRelativeTimestamp()).map(TimeAdjustmentSupport::adjust).orElse(null);
    }

    public final double getEventRelativeTimestamp(TimeUnit timeUnit) {
        return this.getEventRelativeTimestamp().getInUnits(timeUnit);
    }

    public final RelativeTimestamp getEventRawRelativeTimestamp() {
        return this.getEventRelativeTimestampEx();
    }

    protected RelativeTimestamp getEventRelativeTimestampEx() {
        return this.logRelativeTimestamp;
    }

    public final boolean isFieldDefined(Field field) {
        return dataMap.get(this.getClass()).isDefined(this, field);
    }

    public final boolean isFieldDependsOn(Field field1, Field field2) {
        DataClassData classData = dataMap.get(this.getClass());
        FieldInfo fieldInfo = (FieldInfo)classData.get(field1);
        if (fieldInfo != null) {
            for (Field f : fieldInfo.dependsOn) {
                if (!field2.equals(f)) continue;
                return true;
            }
        }
        return false;
    }

    public static LogRecord cast(Object record) {
        return record instanceof LogRecord ? (LogRecord)record : null;
    }

    protected final void setFieldValue(Field field, Object value) throws IllegalArgumentException {
        try {
            DataClassData classData = LogRecord.getDataClassData(this.getClass());
            field.set(this, value);
            classData.setDefined(this, field, true);
        }
        catch (IllegalAccessException | SecurityException ex) {
            Logger.getLogger(LogRecord.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Double getDoubleValue(Field fld, LogUnits targetUnits) {
        if (this.isFieldDefined(fld)) {
            Object val = this.getFieldValue(fld);
            if (val instanceof Number) {
                try {
                    return LogRecord.getFieldUnits(fld).convertTo(((Number)val).doubleValue(), targetUnits);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(LogRecord.class.getName()).log(Level.SEVERE, String.format("Exception while converting data for record of type %s, field %s: %s", this.getClass().getName(), fld.getName(), ex));
                }
            }
            if (val instanceof LogFieldTypes.LogFieldType) {
                try {
                    return ((LogFieldTypes.LogFieldType)val).getDoubleValue(targetUnits);
                }
                catch (OperationNotSupportedException ex) {
                    Logger.getLogger(LogRecord.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return null;
    }

    public Object getFieldValue(Field fld) {
        try {
            return fld.get(this);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            Logger.getLogger(LogRecord.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getFieldValueAsString(Field fld) {
        Object value = this.getFieldValue(fld);
        if (value instanceof Double || value instanceof Float) {
            DecimalFormat df = new DecimalFormat("#.#");
            df.setMaximumFractionDigits(4);
            return df.format(value);
        }
        return value == null ? null : value.toString();
    }

    protected boolean isPrimaryField(Field field) {
        return field.getAnnotation(LogLineField.class) != null;
    }

    void setLineNumberAndRelativeLogTimestamp(LogRecord line, int logLineNumber, RelativeTimestamp logTimestamp) {
        line.logRelativeTimestamp = logTimestamp == null ? RelativeTimestamp.of(0.0, TimeUnit.MINUTES) : logTimestamp;
        line.logLineNumber = logLineNumber;
    }

    void setRelativeLogTimestamp(LogRecord line, RelativeTimestamp logTimestamp) {
        line.logRelativeTimestamp = logTimestamp == null ? RelativeTimestamp.of(0.0, TimeUnit.MINUTES) : logTimestamp;
    }

    static {
        LogRecord.init(null);
        LogDataFieldsAccessor.setInstance(new FieldsAccessor());
        unitsCache = new ConcurrentHashMap();
    }

    private static final class UnmodifiablePhaseInfoList
    extends PhaseInfoList {
        private static final UnmodifiablePhaseInfoList EMPTY = new UnmodifiablePhaseInfoList();
        private final int m;

        private UnmodifiablePhaseInfoList() {
            super("", TimeUnit.MILLISECONDS);
            this.m = this.modCount;
        }

        private UnmodifiablePhaseInfoList(PhaseInfoList list) {
            super(list.description, list.timeUnits);
            this.addAll(list);
            this.m = this.modCount;
        }

        @Override
        public PhaseInfo get(int index) {
            if (this.m != this.modCount) {
                throw new IllegalStateException("PhaseInfoList cannot be modified");
            }
            return (PhaseInfo)super.get(index);
        }
    }

    public static class PhaseInfoList
    extends ArrayList<PhaseInfo> {
        private final TimeUnit timeUnits;
        private final String description;

        public PhaseInfoList(String description, TimeUnit timeUnits) {
            this.description = description;
            this.timeUnits = timeUnits;
        }

        public TimeUnit getTimeUnits() {
            return this.timeUnits;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static final class PhaseInfo {
        public final RelativeTimestamp start;
        public final RelativeTimestamp end;
        public final String name;

        public PhaseInfo(RelativeTimestamp start, RelativeTimestamp end, String name) {
            this.start = start;
            this.end = end;
            this.name = name;
        }
    }

    private static class FieldInfo {
        private final FieldSetterSupport.FieldSetter setter;
        private final int idx;
        private final LogUnits defaultUnits;
        private final Field[] dependsOn;

        private FieldInfo(Class<? extends LogRecord> klass, Field field, int idx) {
            this.idx = idx <= 63 ? idx : 63 - idx;
            this.setter = FieldSetterSupport.getSetterFor(field.getType());
            if (this.setter == null) {
                throw new InternalError("Unhandled type " + field.getType() + " of a field " + field.getName());
            }
            LogRecordCalculatedField logRecordCalculatedFieldAnnotation = field.getAnnotation(LogRecordCalculatedField.class);
            if (logRecordCalculatedFieldAnnotation == null) {
                this.dependsOn = new Field[0];
            } else {
                String[] dependsOnFields = logRecordCalculatedFieldAnnotation.deps();
                this.dependsOn = new Field[dependsOnFields.length];
                int i = 0;
                for (String dep : dependsOnFields) {
                    try {
                        this.dependsOn[i++] = klass.getField(dep);
                    }
                    catch (NoSuchFieldException | SecurityException ex) {
                        Logger.getLogger(LogRecord.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            LogLineField logLineFieldAnnotation = field.getAnnotation(LogLineField.class);
            this.defaultUnits = logLineFieldAnnotation == null ? LogUnits.UNSPECIFIED : logLineFieldAnnotation.defaultUnits();
        }
    }

    private static class DataClassData
    extends HashMap<Field, FieldInfo> {
        private DataClassData() {
        }

        public void setDefined(LogRecord line, Field field, boolean defined) {
            int idx = ((FieldInfo)this.get((Object)field)).idx;
            if (defined) {
                if (idx >= 0) {
                    line.bitmap1 |= 1L << idx;
                } else {
                    line.bitmap2 |= 1L << -idx;
                }
            } else if (idx >= 0) {
                line.bitmap1 &= 1L << idx ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                line.bitmap2 &= 1L << -idx ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }

        private Boolean isDefined(LogRecord line, Field field) {
            int idx = ((FieldInfo)this.get((Object)field)).idx;
            if (idx >= 0) {
                return (line.bitmap1 & 1L << idx) != 0L;
            }
            return (line.bitmap2 & 1L << -idx) != 0L;
        }
    }

    private static final class FieldsAccessor
    extends LogDataFieldsAccessor {
        private FieldsAccessor() {
        }

        @Override
        public void resolveDefinedFields(LogRecord line) {
            Class<?> klass = line.getClass();
            DataClassData classData = dataMap.get(klass);
            classData.keySet().forEach(field -> classData.setDefined(line, (Field)field, this.resolveField(line, classData, (Field)field)));
        }

        private boolean resolveField(LogRecord inst, DataClassData classData, Field field) {
            if (inst.isFieldDefined(field)) {
                return true;
            }
            if (inst.isPrimaryField(field)) {
                return false;
            }
            FieldInfo info = (FieldInfo)classData.get(field);
            for (Field dep : info.dependsOn) {
                if (this.resolveField(inst, classData, dep)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void setFieldValue(LogRecord record, Field field, Object value) throws IllegalArgumentException {
            record.setFieldValue(field, value);
        }

        @Override
        public void setFieldValueFromString(LogRecord record, Field field, CharSequence value) throws IllegalArgumentException {
            try {
                DataClassData classData = LogRecord.getDataClassData(record.getClass());
                FieldInfo info = (FieldInfo)classData.get(field);
                if (info.setter.setField(record, field, value, info.defaultUnits)) {
                    classData.setDefined(record, field, true);
                }
            }
            catch (SecurityException ex) {
                throw new InternalError("Should not happen");
            }
        }
    }
}

