/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.model.api;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogRecordsList;
import com.azul.log.model.spi.LogDataAggregator;
import com.azul.log.model.spi.LogDataConverter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogRecordsMap
extends HashMap<Class<? extends LogRecord>, LogRecordsList<? extends LogRecord>> {
    private final HashMap<Integer, LogRecord> lineToRecord = new HashMap();

    public <T extends LogRecord> LogRecordsList<T> getRecords(Class<? extends LogRecord> klass, LogDataAggregator aggregator, LogDataConverter converter, Method filterMethod, Map<Field, String> fieldFilters) {
        LogRecordsList records = (LogRecordsList)this.get(klass);
        if (records == null) {
            return LogRecordsList.emptyList();
        }
        if (converter == null && filterMethod == null && (fieldFilters == null || fieldFilters.isEmpty())) {
            return records;
        }
        LogRecordsList<LogRecord> filteredRecords = new LogRecordsList<LogRecord>(aggregator, converter);
        block4: for (LogRecord record : records) {
            if (filterMethod != null) {
                try {
                    if (!((Boolean)filterMethod.invoke((Object)record, new Object[0])).booleanValue()) {
                        continue;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    if (ex.getCause() instanceof AccessControlException) {
                        Logger.getLogger(LogRecordsMap.class.getName()).log(Level.SEVERE, "Filter method {0} of custom defined class {1} is unsafe to use! The filter was ignored and some data might be missing from the charts it is used for.", new Object[]{filterMethod.getName(), klass.getSimpleName()});
                        return LogRecordsList.emptyList();
                    }
                    Logger.getLogger(LogRecordsMap.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fieldFilters != null) {
                for (Map.Entry<Field, String> fieldFilter : fieldFilters.entrySet()) {
                    Field filterField = fieldFilter.getKey();
                    String filterValue = fieldFilter.getValue();
                    try {
                        Object value = filterField.get(record);
                        if (value != null && value.toString().contains(filterValue)) continue;
                        continue block4;
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        Logger.getLogger(LogRecordsMap.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            if (converter != null && converter.getValue(record) == null) continue;
            filteredRecords.add(record);
        }
        return filteredRecords;
    }

    public <T extends LogRecord> void addRecord(T record) {
        Class<?> klass = record.getClass();
        LogRecordsList list = this.computeIfAbsent(klass, k -> new LogRecordsList(null, null));
        list.add(record);
        this.lineToRecord.put(record.getLogLineNumber(), record);
    }

    long countRecords() {
        return this.values().stream().map(LogRecordsList::size).reduce(0, Integer::sum).intValue();
    }

    public LogRecord getRecordAtLine(int lineNumber) {
        return this.lineToRecord.get(lineNumber);
    }
}

