/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.api;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.spi.LogRecordLabelConverter;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.utils.TextUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.OperationNotSupportedException;

public final class LogFieldTypes {
    private LogFieldTypes() {
    }

    public static class DistinctValueType
    extends LogFieldType {
        protected final int id;

        protected DistinctValueType(int id) {
            this.id = id;
        }

        @Override
        public final Double getDoubleValue(LogUnits targetUnits) {
            return this.id;
        }

        public static <T extends DistinctValueType> T fromString(Class<T> klass, DistinctValuesSupport<T> support, String value) {
            return (T)support.computeIfAbsent(value, v -> {
                try {
                    return (DistinctValueType)klass.getConstructor(Integer.TYPE).newInstance(support.nextID());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    throw new IllegalArgumentException();
                }
            });
        }
    }

    public static class DistinctValuesLabelConverter<T extends DistinctValueType>
    implements LogRecordLabelConverter {
        private final DistinctValuesSupport<T> support;

        protected DistinctValuesLabelConverter(DistinctValuesSupport<T> support) {
            this.support = support;
        }

        @Override
        public final String convert(double value) {
            return this.support.getLabel(value);
        }

        @Override
        public final String[] getLabels() {
            return this.support.getLabels();
        }
    }

    public static final class DistinctValuesSupport<T extends DistinctValueType> {
        private final AtomicInteger counter = new AtomicInteger();
        private final List<String> labels = new ArrayList<String>();
        private final Map<String, T> values = new HashMap<String, T>();
        private final Map<String, String> valueToLabelMap;

        public DistinctValuesSupport() {
            this(null);
        }

        public DistinctValuesSupport(Map<String, String> valueToLabelMap) {
            this.valueToLabelMap = valueToLabelMap;
        }

        public T computeIfAbsent(String key, Function<String, T> mappingFunction) {
            DistinctValueType val = (DistinctValueType)this.values.get(key);
            if (val == null) {
                val = (DistinctValueType)mappingFunction.apply(key);
                this.labels.add(this.valueToLabel(key));
                this.values.put(key, val);
            }
            return (T)val;
        }

        public String getLabel(double value) {
            return this.labels.get(Double.valueOf(value).intValue());
        }

        public String[] getLabels() {
            return this.labels.toArray(new String[0]);
        }

        private int nextID() {
            return this.counter.getAndIncrement();
        }

        private String valueToLabel(String value) {
            String label = this.valueToLabelMap == null ? null : this.valueToLabelMap.get(value);
            return label == null ? value : label;
        }
    }

    public static class Duration
    extends LogFieldType
    implements Comparable<Duration> {
        private final long nanoseconds;

        public Duration(double value, LogUnits units) {
            this((long)units.convertTo(Math.max(0.0, value), LogUnits.NANOSECONDS));
        }

        public Duration(long nanoseconds) {
            this.nanoseconds = Math.max(0L, nanoseconds);
        }

        public static Duration fromString(String info, LogUnits defaultUnits) throws ParserException {
            return TextUtils.parseDuration(info, defaultUnits);
        }

        public long getNanos() {
            return this.nanoseconds;
        }

        public String toString() {
            return String.valueOf(this.nanoseconds);
        }

        public Duration add(Duration duration) {
            return new Duration(this.nanoseconds + duration.nanoseconds);
        }

        public Duration subtract(Duration duration) {
            return new Duration(Math.max(0L, this.nanoseconds - duration.nanoseconds));
        }

        @Override
        public int compareTo(Duration o) {
            return Long.compare(this.nanoseconds, o.nanoseconds);
        }

        @Override
        public Double getDoubleValue(LogUnits targetUnits) {
            return LogUnits.NANOSECONDS.convertTo(this.getNanos(), targetUnits);
        }
    }

    public static final class Size
    extends LogFieldType {
        private final long bytes;

        public static Size of(long size, LogUnits units) {
            return new Size((long)units.convertTo(size, LogUnits.BYTES));
        }

        private Size(long bytes) {
            this.bytes = bytes;
        }

        public static Size fromString(String info, LogUnits defaultUnits) throws ParserException {
            Long size = TextUtils.parseSize(info, defaultUnits);
            return size == null ? null : new Size(size);
        }

        public long getBytes() {
            return this.bytes;
        }

        public String toString() {
            return String.valueOf(this.bytes);
        }

        @Override
        public Double getDoubleValue(LogUnits targetUnits) {
            return LogUnits.BYTES.convertTo(this.bytes, targetUnits);
        }

        public Size subtract(Size size) {
            return new Size(this.bytes - size.bytes);
        }
    }

    public static abstract class LogFieldType {
        private static final ConcurrentHashMap<Class<? extends LogFieldType>, Method> cache = new ConcurrentHashMap();

        public static <T extends LogFieldType> T parse(String info, Class<T> type, LogUnits defaultUnits) {
            try {
                Method method = cache.get(type);
                if (method == null) {
                    try {
                        method = type.getMethod("fromString", String.class, LogUnits.class);
                        cache.putIfAbsent(type, method);
                    }
                    catch (NoSuchMethodException ex) {
                        Logger.getLogger(LogFieldTypes.class.getName()).log(Level.SEVERE, "type: " + type + "; value: " + info, ex);
                        throw new InternalError(ex.getMessage());
                    }
                }
                return (T)((LogFieldType)method.invoke(null, new Object[]{info, defaultUnits}));
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(LogFieldTypes.class.getName()).log(Level.SEVERE, "type: " + type + "; value: " + info, ex);
                return null;
            }
        }

        public Double getDoubleValue(LogUnits targetUnits) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }
}

