/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.api;

import com.azul.log.advisor.api.Advisor;
import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogModel;
import com.azul.log.parser.api.LogParserBase;
import com.azul.log.parser.api.LogReader;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.spi.LogParserImpl;
import com.azul.log.parser.spi.LogStreamHandler;
import com.azul.log.parser.utils.TextUtils;
import com.azul.log.utils.ProgressModel;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.openide.util.lookup.ProxyLookup;

public final class LogParser
extends LogParserBase {
    private final LogParserImpl<?> parser;
    private BiFunction<Integer, String, Boolean> lineProcessor;
    private long logFileDigest;

    LogParser(LogParserImpl<?> parser) {
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogFile parse(ProgressModel progress) throws IOException {
        this.lineProcessor = this.streamHandlers.isEmpty() ? this::parseLine : this::processLine;
        try (LogReader reader = this.parser.createReader(progress);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (this.lineProcessor.apply(reader.currentLineNumber(), line).booleanValue()) continue;
                throw new ParserException("File parse failed");
            }
            this.logFileDigest = reader.getDigest();
        }
        finally {
            this.parser.teardown();
        }
        return new LogFile(new ProxyLookup(this.parser.getLookup(), Advisor.process(this.parser.getModel(), this.parser.getLookup())), this.logFileDigest);
    }

    @Override
    public LogModel getModel() {
        return this.parser.getModel();
    }

    private boolean processLine(Integer lineNumber, String line) {
        Iterator it = this.streamHandlers.iterator();
        while (it.hasNext()) {
            try {
                if (((LogStreamHandler)it.next()).processLine(lineNumber, line)) continue;
                it.remove();
            }
            catch (Exception ex) {
                return this.processException(lineNumber, line, ex);
            }
        }
        if (this.streamHandlers.isEmpty()) {
            this.lineProcessor = this::parseLine;
        }
        return this.parseLine(lineNumber, line);
    }

    private boolean parseLine(Integer lineNumber, String line) {
        try {
            this.parser.processLine((int)lineNumber, TextUtils.trim(line));
            return true;
        }
        catch (ParserException ex) {
            return this.processException(lineNumber, line, ex);
        }
    }

    private boolean processException(Integer lineNumber, String line, Exception ex) {
        ParserException pex = new ParserException((int)lineNumber, line, ex);
        return this.exceptionHandlers.stream().map(h -> h.handleException(pex)).reduce(Boolean.TRUE, Boolean::logicalAnd);
    }
}

