/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.spi.ParserState;
import com.azul.log.parser.support.LogDataFieldsAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class LogLineParser<T extends LogRecord, S extends ParserState> {
    protected final LogDataFieldsAccessor accessor = LogDataFieldsAccessor.getInstance();

    public abstract List<T> parseDataChunk(CharSequence var1) throws ParserException;

    public void postProcessRecord(T record, S state) {
    }

    protected final <R> LogRecordFieldSetter<R> fieldSetter(Class<? extends LogRecord> klass, String name) throws NoSuchFieldException, NoSuchMethodException {
        return new LogRecordFieldSetter(klass.getField(name));
    }

    public static final class LogRecordFieldSetter<T> {
        private final LogDataFieldsAccessor accessor = LogDataFieldsAccessor.getInstance();
        private final Field field;
        private final Method fromString;

        private LogRecordFieldSetter(Field field) throws NoSuchMethodException {
            this.field = field;
            this.fromString = field.getType().getMethod("fromString", String.class, LogUnits.class);
        }

        public T assign(LogRecord record, T value) throws IllegalArgumentException {
            this.accessor.setFieldValue(record, this.field, value);
            return value;
        }

        public T assign(LogRecord record, String value) throws IllegalArgumentException, InvocationTargetException, IllegalAccessException {
            return this.assign(record, value, LogUnits.UNSPECIFIED);
        }

        public T assign(LogRecord record, String value, LogUnits units) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return (T)this.assign(record, this.fromString.invoke(null, new Object[]{value, units}));
        }
    }
}

