/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.model.api.LogModel;
import com.azul.log.parser.impl.c4.utils.C4_LogFilesSupport;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class C4_LogModel
extends LogModel {
    private final List<C4_LogFilesSupport.C4_GCLogFile> logFiles;
    private String logUID;

    C4_LogModel(List<C4_LogFilesSupport.C4_GCLogFile> logFiles) {
        super("C4");
        this.logFiles = Collections.unmodifiableList(logFiles);
    }

    @Override
    protected String calculateLogName() {
        return C4_LogFilesSupport.getGCLogName(this.logFiles);
    }

    @Override
    protected long calculateLogSize() throws IOException {
        return C4_LogFilesSupport.getSize(this.logFiles);
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return C4_LogFilesSupport.newInputStream(this.logFiles);
    }

    @Override
    public List<Path> getPaths() {
        return this.logFiles.stream().map(C4_LogFilesSupport.C4_GCLogFile::getPath).collect(Collectors.toList());
    }

    public List<C4_LogFilesSupport.C4_GCLogFile> getGCLogFiles() {
        return this.logFiles;
    }

    @Override
    public String getLogUID() {
        return this.logUID;
    }

    public void setLogUID(String logUID) {
        this.logUID = logUID;
    }
}

